/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.instancio.Random;
import org.instancio.feed.FeedSpec;
import org.instancio.feed.FeedSpecAnnotations;
import org.instancio.feed.FunctionProvider;
import org.instancio.feed.PostProcessor;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.feed.DataStore;
import org.instancio.internal.feed.InternalFeed;
import org.instancio.internal.feed.InternalFeedContext;
import org.instancio.internal.feed.SpecMethod;
import org.instancio.internal.generator.misc.SupplierBackedGenerator;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.PropertyBitSet;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.internal.util.StringConverters;
import org.instancio.internal.util.StringUtils;
import org.instancio.settings.FeedDataAccess;
import org.instancio.settings.FeedDataEndAction;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFeed<R>
implements InternalFeed {
    private static final boolean UPDATE_BITSET = true;
    private final DataStore<R> dataStore;
    private final InternalFeedContext<?> feedContext;
    private final String tagValue;
    private final GeneratorContext generatorContext;
    private final PropertyBitSet propertyBitSet;
    private final Class<?> feedClass;
    private final AtomicInteger sequentialAccessIndex = new AtomicInteger(-1);
    private R currentEntry;

    protected AbstractFeed(InternalFeedContext<?> feedContext, DataStore<R> dataStore) {
        this.dataStore = dataStore;
        this.feedContext = feedContext;
        this.generatorContext = feedContext.getGeneratorContext();
        this.propertyBitSet = new PropertyBitSet();
        this.tagValue = feedContext.getTagValue();
        this.feedClass = feedContext.getFeedClass();
    }

    protected abstract String getValue(String var1);

    @Override
    public final InternalFeedContext<?> getFeedContext() {
        return this.feedContext;
    }

    @Override
    public Set<String> getFeedProperties() {
        Method[] methods;
        HashSet<String> properties = new HashSet<String>(this.dataStore.getPropertyKeys());
        for (Method method : methods = this.feedClass.getDeclaredMethods()) {
            if (method.getReturnType() != FeedSpec.class) continue;
            properties.add(method.getName());
        }
        return properties;
    }

    @Override
    public final <T> FeedSpec<T> createSpec(SpecMethod specMethod, Object[] args) {
        return this.createSpecInternal(specMethod, args, true);
    }

    @Override
    public final <T> FeedSpec<T> createSpec(String propertyName, Class<T> targetType) {
        Function<String, T> converter = StringConverters.getConverter(targetType);
        Supplier<T> supplier = this.createSupplier(propertyName, converter, true);
        return this.createSpecWithPostProcessors(supplier, Collections.emptyList(), false);
    }

    protected final R getCurrentEntry() {
        return this.currentEntry;
    }

    protected final GeneratorContext getGeneratorContext() {
        return this.generatorContext;
    }

    protected final Class<?> getFeedClass() {
        return this.feedClass;
    }

    protected final DataStore<R> getDataStore() {
        return this.dataStore;
    }

    protected final int getPropertyIndex(String propertyKey) {
        int index = this.getDataStore().indexOf(propertyKey);
        if (index != -1) {
            return index;
        }
        throw Fail.withUsageError(ErrorMessageUtils.feedWithInvalidMethodName(this.getFeedClass(), propertyKey, this.getDataStore().getPropertyKeys()), new Object[0]);
    }

    private <T> FeedSpec<T> createSpecInternal(SpecMethod specMethod, Object[] args, boolean updateBitSet) {
        Supplier<T> resultSupplier = this.getValueSupplier(specMethod, args, updateBitSet);
        List<PostProcessor<T>> postProcessors = AbstractFeed.getPostProcessors(specMethod);
        return this.createSpecWithPostProcessors(resultSupplier, postProcessors, specMethod.hasNullableAnnotation());
    }

    private <T> FeedSpec<T> createSpecWithPostProcessors(Supplier<T> resultSupplier, List<PostProcessor<T>> postProcessors, boolean isNullable) {
        Supplier supplier = postProcessors.isEmpty() ? resultSupplier : () -> {
            Object processed = resultSupplier.get();
            for (PostProcessor p : postProcessors) {
                processed = p.process(processed, this.getGeneratorContext().random());
            }
            return processed;
        };
        return new SupplierBackedGenerator<T>(this.getGeneratorContext(), supplier).nullable(isNullable);
    }

    private <T> FeedSpec<T> createFeedSpecInternal(SpecMethod specMethod) {
        return this.createSpecInternal(specMethod, null, false);
    }

    private <T> Supplier<T> getValueSupplier(SpecMethod specMethod, Object[] args, boolean updateBitSet) {
        if (specMethod.isDeclaredByFeedInterface()) {
            String propertyNameArg = (String)ApiValidator.notNull(args[0], "'propertyName' must not be null");
            if (args.length == 1) {
                Function converter = StringConverters.getConverter(specMethod.getTargetType());
                return this.createSupplier(propertyNameArg, converter, updateBitSet);
            }
            if (args.length == 2) {
                if (args[1] instanceof Function) {
                    Function converter = (Function)ApiValidator.notNull(args[1], "'converter' function must not be null");
                    return this.createSupplier(propertyNameArg, converter, updateBitSet);
                }
                Class targetTypeParameter = (Class)ApiValidator.notNull(args[1], "'targetType' must not be null");
                Function converter = StringConverters.getConverter(targetTypeParameter);
                return this.createSupplier(propertyNameArg, converter, updateBitSet);
            }
        }
        String key = specMethod.getDataPropertyName();
        if (specMethod.getGeneratedSpec() != null) {
            return () -> super.getGeneratedSpecValue(specMethod.getGeneratedSpec().value());
        }
        if (specMethod.getFunctionSpec() != null) {
            return () -> super.getFunctionSpecValue(specMethod, specMethod.getFunctionSpec());
        }
        if (specMethod.getTemplateSpec() != null) {
            return () -> super.getTemplateSpecValue(specMethod.getTemplateSpec());
        }
        FeedSpecAnnotations.WithStringMapper withStringMapper = specMethod.getAnnotation(FeedSpecAnnotations.WithStringMapper.class);
        Function<String, Object> converter = withStringMapper != null ? ReflectionUtils.newInstance(withStringMapper.value()) : StringConverters.getConverter(specMethod.getTargetType());
        return this.createSupplier(key, converter, updateBitSet);
    }

    private <T> Supplier<T> createSupplier(String propertyKey, Function<String, T> converter, boolean updateBitSet) {
        return () -> {
            String value = this.updateState(propertyKey, updateBitSet).getValue(propertyKey);
            if (value == null) {
                return null;
            }
            try {
                return converter.apply(value);
            }
            catch (Exception ex) {
                throw Fail.withUsageError(ErrorMessageUtils.errorMappingStringToTargetType(propertyKey, value, ex), ex);
            }
        };
    }

    private AbstractFeed<R> updateState(String propertyName, boolean updateBitSet) {
        if (this.currentEntry == null) {
            this.currentEntry = this.getNext();
        }
        if (updateBitSet) {
            if (this.propertyBitSet.get(propertyName)) {
                this.propertyBitSet.clear();
                this.currentEntry = this.getNext();
            }
            this.propertyBitSet.set(propertyName);
        }
        return this;
    }

    private static <T> List<PostProcessor<T>> getPostProcessors(SpecMethod specMethod) {
        FeedSpecAnnotations.WithPostProcessor withPostProcessor = specMethod.getAnnotation(FeedSpecAnnotations.WithPostProcessor.class);
        if (withPostProcessor == null) {
            return Collections.emptyList();
        }
        Class<? extends PostProcessor<?>>[] processorClasses = withPostProcessor.value();
        ArrayList<PostProcessor<T>> list = new ArrayList<PostProcessor<T>>(processorClasses.length);
        for (Class<? extends PostProcessor<?>> c : processorClasses) {
            list.add(ReflectionUtils.newInstance(c));
        }
        return list;
    }

    private <T> T getGeneratedSpecValue(Class<?> generatorClass) {
        Generator generator = (Generator)ReflectionUtils.newInstance(generatorClass);
        return generator.generate(this.getGeneratorContext().random());
    }

    private <T> T getFunctionSpecValue(SpecMethod parentSpecMethod, FeedSpecAnnotations.FunctionSpec functionSpec) {
        Class<? extends FunctionProvider> providerClass = functionSpec.provider();
        Method functionSpecHandler = this.resolveFunctionSpecHandler(parentSpecMethod, providerClass);
        Class<?>[] params = functionSpecHandler.getParameterTypes();
        boolean declaresRandom = params[params.length - 1] == Random.class;
        String[] componentProperties = functionSpec.params();
        int argsLength = declaresRandom ? componentProperties.length + 1 : componentProperties.length;
        Object[] args = new Object[argsLength];
        if (declaresRandom) {
            args[argsLength - 1] = this.getGeneratorContext().random();
        }
        for (int i = 0; i < componentProperties.length; ++i) {
            String component = componentProperties[i];
            Method method = ReflectionUtils.getZeroArgMethod(this.feedClass, component);
            if (method != null) {
                SpecMethod specMethod = new SpecMethod(method);
                args[i] = this.createFeedSpecInternal(specMethod).get();
                continue;
            }
            if (this.dataStore.contains(component)) {
                args[i] = this.createSpec(component, params[i]).get();
                continue;
            }
            throw Fail.withUsageError(ErrorMessageUtils.feedComponentMethodNotFound(this.feedClass, component, parentSpecMethod), new Object[0]);
        }
        try {
            FunctionProvider provider = ReflectionUtils.newInstance(providerClass);
            return (T)ReflectionUtils.setAccessible(functionSpecHandler).invoke((Object)provider, args);
        }
        catch (Exception ex) {
            throw Fail.withUsageError(ErrorMessageUtils.errorInvokingFunctionSpecHandlerMethod(this.feedClass, providerClass, parentSpecMethod, functionSpecHandler, ex), ex);
        }
    }

    @NotNull
    private Method resolveFunctionSpecHandler(SpecMethod parentSpecMethod, Class<?> providerClass) {
        Method resolvedMethod = null;
        for (Method method : providerClass.getDeclaredMethods()) {
            if (Modifier.isPrivate(method.getModifiers())) continue;
            if (resolvedMethod == null) {
                resolvedMethod = method;
                continue;
            }
            throw Fail.withUsageError(ErrorMessageUtils.invalidFunctionSpecHandlerMethod(this.feedClass, providerClass, parentSpecMethod), new Object[0]);
        }
        if (resolvedMethod == null) {
            throw Fail.withUsageError(ErrorMessageUtils.invalidFunctionSpecHandlerMethod(this.feedClass, providerClass, parentSpecMethod), new Object[0]);
        }
        return resolvedMethod;
    }

    private <T> T getTemplateSpecValue(FeedSpecAnnotations.TemplateSpec templateSpec) {
        String template = templateSpec.value();
        List<String> components = StringUtils.getTemplateKeys(template);
        for (String component : components) {
            String value;
            if (this.dataStore.contains(component)) {
                value = this.getValue(component);
            } else {
                Method method = ReflectionUtils.getZeroArgMethod(this.feedClass, component);
                value = (String)this.createFeedSpecInternal(new SpecMethod(method)).get();
            }
            String replacement = value == null ? "" : value;
            template = template.replace("${" + component + "}", replacement);
        }
        return (T)template;
    }

    private R getNext() {
        if (this.feedContext.getFeedDataAccess() == FeedDataAccess.RANDOM) {
            String tag = this.tagValue == null ? this.generatorContext.random().oneOf(this.dataStore.getTagKeys()) : this.tagValue;
            List<R> tagData = this.dataStore.get(tag);
            return this.generatorContext.random().oneOf(tagData);
        }
        if (this.tagValue == null) {
            int nextIndex = this.nextIndex(this.dataStore.size());
            return this.dataStore.get(nextIndex);
        }
        List<R> tagData = this.dataStore.get(this.tagValue);
        int next = this.nextIndex(tagData.size());
        return tagData.get(next);
    }

    private int nextIndex(int dataSize) {
        this.sequentialAccessIndex.compareAndSet(-1, 0);
        int nextIndex = this.sequentialAccessIndex.getAndIncrement();
        if (nextIndex == dataSize) {
            if (this.feedContext.getFeedDataEndStrategy() == FeedDataEndAction.FAIL) {
                throw Fail.withUsageError(ErrorMessageUtils.feedDataEnd(this.feedClass, this.generatorContext.getSettings()), new Object[0]);
            }
            this.sequentialAccessIndex.set(0);
            nextIndex = this.sequentialAccessIndex.getAndIncrement();
        }
        return nextIndex;
    }
}

