/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.instancio.Random;
import org.instancio.TargetSelector;
import org.instancio.internal.context.BooleanSelectorMap;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.context.SubtypeSelectorMap;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.TypeResolverFacade;
import org.instancio.internal.spi.InternalServiceProvider;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.NotNull;

public final class NodeContext {
    private final int maxDepth;
    private final Settings settings;
    private final Random random;
    private final Map<TypeVariable<?>, Type> rootTypeMap;
    private final BooleanSelectorMap ignoredSelectorMap;
    private final SubtypeSelectorMap subtypeSelectorMap;
    private final BooleanSelectorMap assignmentOriginSelectors;
    private final Map<Class<?>, Class<?>> subtypeMappingFromSettings;
    private final TypeResolverFacade typeResolverFacade;
    private final List<InternalServiceProvider> internalServiceProviders;

    public NodeContext(ModelContext<?> modelContext) {
        this.maxDepth = modelContext.getMaxDepth();
        this.settings = modelContext.getSettings();
        this.random = modelContext.getRandom();
        this.rootTypeMap = modelContext.getRootTypeMap();
        this.ignoredSelectorMap = modelContext.getIgnoreSelectorMap();
        this.subtypeSelectorMap = modelContext.getSubtypeSelectorMap();
        this.assignmentOriginSelectors = modelContext.getAssignmentOriginSelectorMap();
        this.subtypeMappingFromSettings = this.settings.getSubtypeMap();
        this.internalServiceProviders = modelContext.getInternalServiceProviders();
        this.typeResolverFacade = new TypeResolverFacade(modelContext.getServiceProviders().getTypeResolvers());
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Random getRandom() {
        return this.random;
    }

    public Map<TypeVariable<?>, Type> getRootTypeMap() {
        return this.rootTypeMap;
    }

    public Set<TargetSelector> getAssignmentOriginSelectors(InternalNode node) {
        return this.assignmentOriginSelectors.getSelectorMap().getSelectors(node);
    }

    Optional<Class<?>> getSubtype(@NotNull InternalNode node) {
        Optional<Class<?>> subtype = this.subtypeSelectorMap.getSubtype(node);
        if (subtype.isPresent()) {
            return subtype;
        }
        Class<?> subtypeFromSettings = this.subtypeMappingFromSettings.get(node.getRawType());
        return subtypeFromSettings == null ? this.typeResolverFacade.resolve(node.getRawType()) : Optional.of(subtypeFromSettings);
    }

    boolean isIgnored(@NotNull InternalNode node) {
        return this.ignoredSelectorMap.isTrue(node);
    }

    public List<InternalServiceProvider> getInternalServiceProviders() {
        return this.internalServiceProviders;
    }
}

