/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.instancio.internal.nodes.MethodNameResolver;
import org.instancio.internal.nodes.SetterMethodNameNoPrefixResolver;
import org.instancio.internal.nodes.SetterMethodNameWithPrefixResolver;
import org.instancio.internal.util.Fail;
import org.instancio.settings.Keys;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSetterMethodResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSetterMethodResolver.class);
    private final MethodNameResolver setterNameResolver;

    DefaultSetterMethodResolver(Settings settings) {
        this.setterNameResolver = DefaultSetterMethodResolver.getMethodNameResolver(settings.get(Keys.SETTER_STYLE));
    }

    Method getSetter(Field field) {
        String methodName = this.setterNameResolver.resolveFor(field);
        if (methodName != null) {
            try {
                Class<?> klass = field.getDeclaringClass();
                return klass.getDeclaredMethod(methodName, field.getType());
            }
            catch (NoSuchMethodException ex) {
                LOG.trace("Could not find matching setter for field '{}'. Expected method '{}' does not exist", (Object)field, (Object)methodName);
            }
        }
        return null;
    }

    private static MethodNameResolver getMethodNameResolver(SetterStyle style) {
        switch (style) {
            case SET: {
                return new SetterMethodNameWithPrefixResolver("set");
            }
            case WITH: {
                return new SetterMethodNameWithPrefixResolver("with");
            }
            case PROPERTY: {
                return new SetterMethodNameNoPrefixResolver();
            }
        }
        throw Fail.withFataInternalError("Unhandled setter style: %s", new Object[]{style});
    }
}

