/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Year;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.YearSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;
import org.instancio.support.Global;

public class YearGenerator
extends JavaTimeTemporalGenerator<Year>
implements YearSpec {
    static final Year DEFAULT_MIN = Year.of(Constants.DEFAULT_MIN.getYear());
    static final Year DEFAULT_MAX = Year.of(Constants.DEFAULT_MAX.getYear());

    public YearGenerator() {
        this(Global.generatorContext());
    }

    public YearGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX);
    }

    @Override
    public String apiMethod() {
        return "year()";
    }

    @Override
    public YearGenerator past() {
        super.past();
        return this;
    }

    @Override
    public YearGenerator future() {
        super.future();
        return this;
    }

    @Override
    public YearGenerator min(Year min) {
        super.min(min);
        return this;
    }

    @Override
    public YearGenerator max(Year max) {
        super.max(max);
        return this;
    }

    @Override
    public YearGenerator range(Year min, Year max) {
        super.range(min, max);
        return this;
    }

    @Override
    public YearGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    Year getLatestPast() {
        return Year.now().minusYears(1L);
    }

    @Override
    Year getEarliestFuture() {
        return Year.now().plusYears(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.validateStartEnd((Year)this.min, (Year)this.max);
    }

    @Override
    protected Year tryGenerateNonNull(Random random) {
        return Year.of(random.intRange(((Year)this.min).getValue(), ((Year)this.max).getValue()));
    }
}

