/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.instancio.exception.InstancioException;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Verify;
import org.jetbrains.annotations.Nullable;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static Class<?> getArrayClass(@Nullable Type type) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (klass.isArray()) {
                return klass;
            }
            return Array.newInstance(klass, 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return TypeUtils.getArrayClass(rawType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type genericComponent = arrayType.getGenericComponentType();
            return Array.newInstance(TypeUtils.getRawType(genericComponent), 0).getClass();
        }
        throw new IllegalArgumentException("Not an array: " + type);
    }

    public static Type[] getTypeArguments(Type parameterizedType) {
        ParameterizedType pType = (ParameterizedType)parameterizedType;
        return pType.getActualTypeArguments();
    }

    public static <T> Class<T> getRawType(Type type) {
        Verify.notNull(type, "type is null", new Object[0]);
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            Type genericComponentType = ((GenericArrayType)type).getGenericComponentType();
            return TypeUtils.getRawType(genericComponentType);
        }
        ExceptionHandler.conditionalFailOnError(() -> {
            throw new InstancioException("Unhandled type: " + type.getClass().getSimpleName());
        });
        return null;
    }

    public static Class<?> getGenericSuperclassTypeArgument(Class<?> klass) {
        return TypeUtils.findParameterizedSupertype(klass).map(t -> t.getActualTypeArguments()[0]).map(TypeUtils::getRawType).orElse(null);
    }

    private static Optional<ParameterizedType> findParameterizedSupertype(Class<?> klass) {
        if (klass == null) {
            return Optional.empty();
        }
        List<Type> supertypes = TypeUtils.collectSupertypes(klass);
        Optional<Object> parameterizedType = Optional.empty();
        for (Type supertype : supertypes) {
            if (!(supertype instanceof ParameterizedType)) continue;
            parameterizedType = Optional.of((ParameterizedType)supertype);
            break;
        }
        return parameterizedType.isPresent() ? parameterizedType : TypeUtils.findParameterizedSupertype(supertypes);
    }

    private static List<Type> collectSupertypes(Class<?> klass) {
        ArrayList<Type> supertypes = new ArrayList<Type>();
        supertypes.add(klass.getGenericSuperclass());
        supertypes.addAll(Arrays.asList(klass.getGenericInterfaces()));
        supertypes.removeIf(Objects::isNull);
        return supertypes;
    }

    private static Optional<ParameterizedType> findParameterizedSupertype(List<Type> types) {
        for (Type type : types) {
            Optional<ParameterizedType> parameterizedSupertype = TypeUtils.findParameterizedSupertype(TypeUtils.getRawType(type));
            if (!parameterizedSupertype.isPresent()) continue;
            return parameterizedSupertype;
        }
        return Optional.empty();
    }

    public static Type[] getGenericSuperclassTypeArguments(Class<?> klass) {
        if (klass.getGenericSuperclass() instanceof ParameterizedType) {
            ParameterizedType genericSuperclass = (ParameterizedType)klass.getGenericSuperclass();
            return genericSuperclass.getActualTypeArguments();
        }
        return new Type[0];
    }
}

