/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.instancio.Scope;
import org.instancio.internal.selectors.ScopeImpl;

public final class Format {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("\\w+\\.");

    public static String formatField(Field field) {
        return field == null ? null : String.format("%s %s.%s", Format.withoutPackage(field.getType()), Format.withoutPackage(field.getDeclaringClass()), field.getName());
    }

    public static String formatMethod(Method method) {
        return method == null ? null : String.format("%s.%s(%s)", Format.withoutPackage(method.getDeclaringClass()), method.getName(), Format.withoutPackage(method.getParameterTypes()[0]));
    }

    public static String withoutPackage(Type type) {
        return PACKAGE_PATTERN.matcher(type.getTypeName()).replaceAll("");
    }

    public static String formatScopes(List<Scope> scopes) {
        return scopes.stream().map(ScopeImpl.class::cast).map(s -> s.getFieldName() == null ? String.format("scope(%s)", s.getTargetClass().getSimpleName()) : String.format("scope(%s, \"%s\")", s.getTargetClass().getSimpleName(), s.getFieldName())).collect(Collectors.joining(", "));
    }

    public static String getTypeVariablesCsv(Class<?> klass) {
        return Arrays.stream(klass.getTypeParameters()).map(TypeVariable::getName).collect(Collectors.joining(", "));
    }

    public static String firstNonInstancioStackTraceLine(Throwable throwable) {
        for (StackTraceElement element : throwable.getStackTrace()) {
            if (element.getClassName().startsWith("org.instancio")) continue;
            return element.toString();
        }
        return "<unknown location>";
    }

    public static String selectorErrorMessage(String message, String methodName, String invokedMethods, Throwable t) {
        String template = "%n  %s%n  method invocation: %s%n  at %s";
        String invocation = String.format("%s.%s( -> null <- )", invokedMethods, methodName);
        String at = Format.firstNonInstancioStackTraceLine(t);
        return String.format("%n  %s%n  method invocation: %s%n  at %s", message, invocation, at);
    }

    private Format() {
    }
}

