/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.spi;

import java.util.List;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.spi.ServiceProviderContext;

public final class Providers {
    private final List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> generatorProviders;
    private final List<ProviderEntry<InstancioServiceProvider.TypeResolver>> typeResolvers;
    private final List<ProviderEntry<InstancioServiceProvider.TypeInstantiator>> typeInstantiators;

    public Providers(List<InstancioServiceProvider> spList, ServiceProviderContext context) {
        spList.forEach(sp -> sp.init(context));
        this.generatorProviders = ProviderEntry.from(spList, InstancioServiceProvider::getGeneratorProvider);
        this.typeResolvers = ProviderEntry.from(spList, InstancioServiceProvider::getTypeResolver);
        this.typeInstantiators = ProviderEntry.from(spList, InstancioServiceProvider::getTypeInstantiator);
    }

    public List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> getGeneratorProviders() {
        return this.generatorProviders;
    }

    public List<ProviderEntry<InstancioServiceProvider.TypeResolver>> getTypeResolvers() {
        return this.typeResolvers;
    }

    public List<ProviderEntry<InstancioServiceProvider.TypeInstantiator>> getTypeInstantiators() {
        return this.typeInstantiators;
    }
}

