/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.instancio.DepthPredicateSelector;
import org.instancio.DepthSelector;
import org.instancio.PredicateSelector;
import org.instancio.TargetSelector;
import org.instancio.internal.selectors.PredicateSelectorImpl;
import org.instancio.internal.selectors.SelectorBuilder;

abstract class PredicateSelectorBuilderTemplate<T>
implements SelectorBuilder,
DepthSelector,
DepthPredicateSelector {
    private final List<Predicate<T>> predicates = new ArrayList<Predicate<T>>(3);
    private final StringBuilder description = new StringBuilder(128);

    PredicateSelectorBuilderTemplate() {
        this.description.append(this.apiMethod());
    }

    protected abstract PredicateSelectorImpl.Builder createBuilder();

    protected abstract String apiMethod();

    protected final void addPredicate(Predicate<T> predicate) {
        this.predicates.add(predicate);
    }

    protected final StringBuilder description() {
        return this.description;
    }

    @Override
    public final TargetSelector atDepth(int depth) {
        PredicateSelectorImpl copy = (PredicateSelectorImpl)this.build();
        return PredicateSelectorImpl.builder(copy).depth(depth).build();
    }

    @Override
    public final TargetSelector atDepth(Predicate<Integer> predicate) {
        PredicateSelectorImpl copy = (PredicateSelectorImpl)this.build();
        return PredicateSelectorImpl.builder(copy).depth(predicate).build();
    }

    protected final Predicate<T> buildPredicate() {
        Predicate<Object> predicate = Objects::nonNull;
        for (Predicate<T> p : this.predicates) {
            predicate = predicate.and(p);
        }
        return predicate;
    }

    @Override
    public final PredicateSelector build() {
        return this.createBuilder().apiInvocationDescription(this.description.toString()).build();
    }

    public final String toString() {
        return this.description.toString();
    }
}

