/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import java.util.List;
import org.instancio.internal.instantiation.InstantiationStrategy;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.spi.InstancioSpiException;

class ServiceProviderInstantiationStrategy
implements InstantiationStrategy {
    private final List<ProviderEntry<InstancioServiceProvider.TypeInstantiator>> providerEntries;

    ServiceProviderInstantiationStrategy(List<ProviderEntry<InstancioServiceProvider.TypeInstantiator>> providerEntries) {
        this.providerEntries = providerEntries;
    }

    @Override
    public <T> T createInstance(Class<T> klass) {
        for (ProviderEntry<InstancioServiceProvider.TypeInstantiator> entry : this.providerEntries) {
            Object result = entry.getProvider().instantiate(klass);
            if (result == null) continue;
            if (!klass.isAssignableFrom(result.getClass())) {
                throw new InstancioSpiException(String.format("%s instantiated an object of invalid type:%n -> %s%nExpected an instance of:%n -> %s", entry.getInstancioProviderClass(), result.getClass(), klass));
            }
            return klass.cast(result);
        }
        return null;
    }
}

