/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.xml;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.instancio.Random;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.LocalDateTimeGenerator;
import org.instancio.internal.util.ExceptionHandler;

public class XMLGregorianCalendarGenerator
extends AbstractGenerator<XMLGregorianCalendar> {
    private final Generator<LocalDateTime> localDateTimeGenerator;

    public XMLGregorianCalendarGenerator(GeneratorContext context) {
        super(context);
        this.localDateTimeGenerator = new LocalDateTimeGenerator(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    protected XMLGregorianCalendar tryGenerateNonNull(Random random) {
        LocalDateTime localDateTime = this.localDateTimeGenerator.generate(random);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        }
        catch (DatatypeConfigurationException ex) {
            ExceptionHandler.logException("Error generating XMLGregorianCalendar; returning a null", ex, new Object[0]);
            return null;
        }
    }
}

