/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.EanSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.support.Global;

public class EanGenerator
extends AbstractGenerator<String>
implements EanSpec {
    private EanType type = EanType.EAN13;

    public EanGenerator() {
        super(Global.generatorContext());
    }

    public EanGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "ean()";
    }

    @Override
    public EanGenerator type13() {
        this.type = EanType.EAN13;
        return this;
    }

    @Override
    public EanGenerator type8() {
        this.type = EanType.EAN8;
        return this;
    }

    @Override
    public EanGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        String withoutCheckDigit = random.digits(this.type.length - 1);
        int checkDigit = EanGenerator.getCheckDigit(withoutCheckDigit, this.type);
        return withoutCheckDigit + checkDigit;
    }

    private static int getCheckDigit(String s, EanType type) {
        int even = 0;
        int odd = 0;
        for (int i = 0; i < s.length(); ++i) {
            int idx = i + 1;
            int d = s.charAt(i) - 48;
            if (idx % 2 == 0) {
                even += d;
                continue;
            }
            odd += d;
        }
        int sum = type == EanType.EAN8 ? 3 * odd + even : 3 * even + odd;
        return (10 - sum % 10) % 10;
    }

    private static enum EanType {
        EAN8(8),
        EAN13(13);

        private final int length;

        private EanType(int length) {
            this.length = length;
        }
    }
}

