/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.finance;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.CreditCardSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.domain.finance.CCTypeImpl;
import org.instancio.internal.util.LuhnUtils;
import org.instancio.support.Global;
import org.jetbrains.annotations.VisibleForTesting;

public class CreditCardNumberGenerator
extends AbstractGenerator<String>
implements CreditCardSpec {
    private CCTypeImpl cardType;

    public CreditCardNumberGenerator() {
        super(Global.generatorContext());
    }

    public CreditCardNumberGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "creditCard()";
    }

    @Override
    public CreditCardNumberGenerator visa() {
        return this.cardType(CCTypeImpl.CC_VISA);
    }

    @Override
    public CreditCardNumberGenerator masterCard() {
        return this.cardType(CCTypeImpl.CC_MASTERCARD);
    }

    @VisibleForTesting
    CreditCardNumberGenerator cardType(CCTypeImpl cardType) {
        this.cardType = cardType;
        return this;
    }

    @Override
    public CreditCardNumberGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        CCTypeImpl type = this.cardType == null ? random.oneOf(CCTypeImpl.values()) : this.cardType;
        String prefix = random.oneOf(type.getPrefixes()).toString();
        int lengthWithoutCheckDigit = type.getLength() - prefix.length() - 1;
        String withoutCheckDigit = prefix + random.digits(lengthWithoutCheckDigit);
        return withoutCheckDigit + LuhnUtils.getCheckDigit(withoutCheckDigit);
    }
}

