/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesLoader.class);
    private static final String DEFAULT_PROPERTIES_FILE = "instancio.properties";

    private PropertiesLoader() {
    }

    public static Properties loadDefaultPropertiesFile() {
        return PropertiesLoader.load(DEFAULT_PROPERTIES_FILE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties load(String file) {
        Properties properties2 = new Properties();
        try (InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);){
            if (inStream == null) {
                LOG.debug("No '{}' found on classpath", (Object)file);
                Properties properties3 = properties2;
                return properties3;
            }
            LOG.info("Found '{}' on classpath", (Object)file);
            properties2.load(inStream);
            Properties properties = properties2;
            return properties;
        }
        catch (IOException ex) {
            LOG.debug("Failed loading {}", (Object)file);
            return properties2;
        }
    }
}

