/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.instancio.OnCompleteCallback;
import org.instancio.internal.GenerationListener;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHandler
implements GenerationListener {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackHandler.class);
    private final ModelContext<?> context;
    private final Map<InternalNode, List<Object>> resultsForCallbacks = new IdentityHashMap<InternalNode, List<Object>>();

    public CallbackHandler(ModelContext<?> context) {
        this.context = context;
    }

    @Override
    public void objectCreated(InternalNode node, GeneratorResult result) {
        if (result.getValue() == null) {
            return;
        }
        InternalGeneratorHint hint = result.getHints().get(InternalGeneratorHint.class);
        if (hint != null && hint.excludeFromCallbacks()) {
            return;
        }
        Object instance = result.getValue();
        if (!this.getCallbacks(node).isEmpty()) {
            this.resultsForCallbacks.computeIfAbsent(node, res -> new ArrayList()).add(instance);
        }
    }

    public void invokeCallbacks() {
        LOG.trace("Preparing to call {} callback(s)", (Object)this.resultsForCallbacks.size());
        this.resultsForCallbacks.forEach((node, results) -> {
            List<OnCompleteCallback<?>> callbacks = this.getCallbacks((InternalNode)node);
            for (OnCompleteCallback<?> callback : callbacks) {
                LOG.trace("{} results for callbacks generated for: {}", (Object)results.size(), node);
                for (Object result : results) {
                    CallbackHandler.invokeCallback(callback, result);
                }
            }
        });
    }

    private List<OnCompleteCallback<?>> getCallbacks(InternalNode node) {
        return this.context.getCallbacks(node);
    }

    private static void invokeCallback(OnCompleteCallback<?> callback, Object result) {
        try {
            callback.onComplete(result);
        }
        catch (ClassCastException ex) {
            String errorMsg = String.format("onComplete() callback error.%n%nClassCastException was thrown by the callback.%nThis usually happens because the type declared by the callback%ndoes not match the actual type of the target object.%n%nExample:%nonComplete(all(Foo.class), (Bar wrongType) -> {%n               ^^^^^^^^^    ^^^^^^^^^^^^^%n})%n%nCaused by:%n%s", ex.getMessage());
            throw Fail.withUsageError(errorMsg, ex);
        }
    }
}

