/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.impl.OriginatingClasses;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;

final class AnnotatedClassScanner {
    private TreeMap<String, TypeMirror> classes;
    private final Messager messager;
    private final Elements elements;
    private final Element builderElement;
    private final AutoProtoSchemaBuilder builderAnnotation;
    private final Set<String> basePackages;
    private final Set<TypeMirror> includedClasses;
    private final Set<TypeMirror> excludedClasses;
    private final PackageElement packageOfInitializer;
    private final String initializerClassName;
    private final String initializerFQClassName;

    AnnotatedClassScanner(Messager messager, Elements elements, Element builderElement, AutoProtoSchemaBuilder builderAnnotation) {
        if (builderElement.getKind() == ElementKind.PACKAGE && builderAnnotation.className().isEmpty()) {
            throw new AnnotationProcessingException(builderElement, "@AutoProtoSchemaBuilder.className is required when annotating a package.", new Object[0]);
        }
        this.messager = messager;
        this.elements = elements;
        this.builderElement = builderElement;
        this.builderAnnotation = builderAnnotation;
        this.includedClasses = this.getClasses(true);
        this.excludedClasses = this.getClasses(false);
        this.basePackages = this.getBasePackages();
        this.packageOfInitializer = elements.getPackageOf(builderElement);
        this.initializerClassName = builderAnnotation.className().isEmpty() ? builderElement.getSimpleName() + "Impl" : builderAnnotation.className();
        this.initializerFQClassName = this.packageOfInitializer.isUnnamed() ? this.initializerClassName : this.packageOfInitializer.getQualifiedName().toString() + '.' + this.initializerClassName;
    }

    String getInitializerClassName() {
        return this.initializerClassName;
    }

    String getInitializerFQClassName() {
        return this.initializerFQClassName;
    }

    Collection<? extends TypeMirror> getClasses() {
        return this.classes.values();
    }

    void discoverClasses(RoundEnvironment roundEnv) throws AnnotationProcessingException {
        this.classes = new TreeMap();
        if (this.includedClasses.isEmpty()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoField.class)) {
                this.visitProtoField(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoFactory.class)) {
                this.visitProtoFactory(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnumValue.class)) {
                this.visitProtoEnumValue(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnum.class)) {
                this.visitProtoEnum(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoMessage.class)) {
                this.visitProtoMessage(element);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoName.class)) {
                this.visitProtoName(element);
            }
            for (TypeElement typeElement : this.getPreviouslyProcessedElements()) {
                this.visitTypeElement(typeElement);
            }
        } else {
            for (TypeMirror typeMirror : this.includedClasses) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.collectClasses(typeElement);
            }
        }
    }

    private void visitTypeElement(TypeElement e) {
        if (e.getAnnotation(ProtoName.class) != null) {
            this.visitProtoName(e);
        }
        if (e.getAnnotation(ProtoMessage.class) != null) {
            this.visitProtoMessage(e);
        }
        if (e.getAnnotation(ProtoEnum.class) != null) {
            this.visitProtoEnum(e);
        }
        for (Element element : e.getEnclosedElements()) {
            if (element.getAnnotation(ProtoField.class) != null) {
                this.visitProtoField(element);
            }
            if (element.getAnnotation(ProtoEnumValue.class) != null) {
                this.visitProtoEnumValue(element);
            }
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) continue;
            this.visitTypeElement((TypeElement)element);
        }
    }

    private void visitProtoFactory(Element e) {
        Element enclosingElement = e.getEnclosingElement();
        if (e.getKind() != ElementKind.METHOD && e.getKind() != ElementKind.CONSTRUCTOR || enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoFactory can only be applied to constructors and methods.", new Object[0]);
        }
        this.collectClasses((TypeElement)enclosingElement);
    }

    private void visitProtoField(Element e) {
        Element enclosingElement = e.getEnclosingElement();
        if (e.getKind() != ElementKind.METHOD && e.getKind() != ElementKind.FIELD || enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoField can only be applied to fields and methods.", new Object[0]);
        }
        this.collectClasses((TypeElement)enclosingElement);
    }

    private void visitProtoEnumValue(Element e) {
        Element enclosingElement = e.getEnclosingElement();
        if (e.getKind() != ElementKind.ENUM_CONSTANT || enclosingElement.getKind() != ElementKind.ENUM) {
            throw new AnnotationProcessingException(e, "@ProtoEnumValue can only be applied to enum constants.", new Object[0]);
        }
        this.collectClasses((TypeElement)enclosingElement);
    }

    private void visitProtoName(Element e) {
        if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE && e.getKind() != ElementKind.ENUM) {
            throw new AnnotationProcessingException(e, "@ProtoName can only be applied to classes, interfaces and enums.", new Object[0]);
        }
        this.collectClasses((TypeElement)e);
    }

    private void visitProtoMessage(Element e) {
        if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoMessage can only be applied to classes and interfaces.", new Object[0]);
        }
        this.collectClasses((TypeElement)e);
    }

    private void visitProtoEnum(Element e) {
        if (e.getKind() != ElementKind.CLASS && e.getKind() != ElementKind.INTERFACE) {
            throw new AnnotationProcessingException(e, "@ProtoEnum can only be applied to enums.", new Object[0]);
        }
        this.collectClasses((TypeElement)e);
    }

    private Set<TypeElement> getPreviouslyProcessedElements() {
        OriginatingClasses originatingClasses;
        Set<TypeElement> typeElements = Collections.emptySet();
        TypeElement initializer = this.elements.getTypeElement(this.initializerFQClassName);
        if (initializer != null && (originatingClasses = initializer.getAnnotation(OriginatingClasses.class)) != null) {
            typeElements = new HashSet<TypeElement>(originatingClasses.value().length);
            for (String name : originatingClasses.value()) {
                TypeElement typeElement = this.elements.getTypeElement(name);
                if (typeElement == null) continue;
                typeElements.add(typeElement);
            }
        }
        return typeElements;
    }

    boolean isClassIncluded(String classFQN) {
        TypeElement typeElement = this.elements.getTypeElement(classFQN);
        TypeMirror type = typeElement.asType();
        if (this.excludedClasses.contains(type)) {
            return false;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (!this.isPackageIncluded(packageOfElement)) {
            return false;
        }
        if (!this.includedClasses.isEmpty() && this.includedClasses.contains(type)) {
            return true;
        }
        return this.builderAnnotation.autoImportClasses() || this.includedClasses.isEmpty();
    }

    private Set<String> getBasePackages() {
        if (this.builderAnnotation.value().length == 0 && this.builderAnnotation.basePackages().length == 0) {
            return Collections.emptySet();
        }
        if (this.builderAnnotation.value().length != 0 && this.builderAnnotation.basePackages().length != 0) {
            throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.value and @AutoProtoSchemaBuilder.basePackages are mutually exclusive", new Object[0]);
        }
        boolean usingAlias = true;
        String[] basePackages = this.builderAnnotation.value();
        if (basePackages.length == 0) {
            usingAlias = false;
            basePackages = this.builderAnnotation.basePackages();
        }
        HashSet<String> packages = new HashSet<String>(basePackages.length);
        for (String p : basePackages) {
            if (!SourceVersion.isName(p)) {
                throw new AnnotationProcessingException(this.builderElement, "@AutoProtoSchemaBuilder.%s contains an invalid package name : \"%s\"", usingAlias ? "value" : "basePackages", p);
            }
            packages.add(p);
        }
        return packages;
    }

    private Set<TypeMirror> getClasses(boolean included) {
        List<Object> classes = Collections.emptyList();
        try {
            if (included) {
                this.builderAnnotation.includeClasses();
            } else {
                this.builderAnnotation.excludeClasses();
            }
        }
        catch (MirroredTypesException mte) {
            classes = mte.getTypeMirrors();
        }
        return new LinkedHashSet<TypeMirror>(classes);
    }

    private void collectClasses(TypeElement typeElement) {
        TypeMirror type = typeElement.asType();
        if (this.excludedClasses.contains(type)) {
            return;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (!this.isPackageIncluded(packageOfElement)) {
            return;
        }
        if (this.includedClasses.isEmpty()) {
            if (typeElement.getKind() == ElementKind.INTERFACE || typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return;
            }
            if (packageOfElement.isUnnamed() && !this.packageOfInitializer.isUnnamed() || !packageOfElement.equals(this.packageOfInitializer) && !this.isPublicElement(typeElement)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Type %s is not visible to %s so it is ignored!", typeElement.getQualifiedName(), this.packageOfInitializer.getQualifiedName()), this.builderElement);
                return;
            }
        }
        this.classes.putIfAbsent(typeElement.getQualifiedName().toString(), type);
    }

    private boolean isPublicElement(TypeElement typeElement) {
        block2: {
            Element e = typeElement;
            do {
                if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    return false;
                }
                if ((e = e.getEnclosingElement()) == null || e.getKind() == ElementKind.PACKAGE) break block2;
            } while (e.getKind() == ElementKind.CLASS || e.getKind() == ElementKind.INTERFACE || e.getKind() == ElementKind.ENUM);
            return false;
        }
        return true;
    }

    private boolean isPackageIncluded(PackageElement packageElement) {
        if (this.basePackages.isEmpty()) {
            return true;
        }
        String p = packageElement.getQualifiedName().toString();
        while (true) {
            if (this.basePackages.contains(p)) {
                return true;
            }
            int pos = p.lastIndexOf(46);
            if (pos == -1) break;
            p = p.substring(0, pos);
        }
        return false;
    }
}

