/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.licenses;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.infinispan.tools.Dependency;
import org.infinispan.tools.ToolUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LicenseReplacer {
    private final DocumentBuilder docBuilder;
    private final Document emptyDocument;
    private final Map<String, Node> overwriteArtifacts = new ConcurrentHashMap<String, Node>();
    private Document licensesDoc;
    private boolean verbose;

    LicenseReplacer() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        this.docBuilder = dbf.newDocumentBuilder();
        this.emptyDocument = this.docBuilder.newDocument();
    }

    public static void main(String[] argv) throws Exception {
        LicenseReplacer replacer = new LicenseReplacer();
        File outputFile = new File(System.getProperty("user.dir"), "licenses.xml");
        block17: for (int i = 0; i < argv.length; ++i) {
            switch (argv[i]) {
                case "-v": {
                    replacer.setVerbose();
                    continue block17;
                }
                case "-i": {
                    replacer.loadOverwriteXML(argv[++i]);
                    continue block17;
                }
                case "-o": {
                    outputFile = new File(argv[++i]);
                    continue block17;
                }
                case "-l": {
                    replacer.loadLicenseFromXML(argv[++i]);
                }
            }
        }
        if (replacer.licensesDoc == null || replacer.licensesDoc == replacer.emptyDocument) {
            System.err.println("License XML file is invalid or missing. Did you use '-l' option?");
            System.exit(1);
        }
        if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            System.err.printf("Unable to create output file \"%s\"%n", outputFile.getAbsolutePath());
            System.exit(2);
        }
        if (replacer.overwriteArtifacts.isEmpty()) {
            System.err.println("Licenses overwrite XML file is empty or missing! Did you use '-i' option?");
            System.exit(3);
        }
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            replacer.write(os);
            if (replacer.verbose) {
                System.out.printf("Wrote merged licenses to %s%n", outputFile);
            }
        }
        ToolUtils.removeEmptyLinesFromFile(outputFile);
    }

    public void write(OutputStream os) throws TransformerException {
        Document aggregated = this.docBuilder.newDocument();
        Element aggregatedDependencies = (Element)aggregated.appendChild(aggregated.createElement("licenseSummary")).appendChild(aggregated.createElement("dependencies"));
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.licensesDoc != null && this.licensesDoc != this.emptyDocument) {
            for (Dependency dep : ToolUtils.parseXMLDependencies(this.licensesDoc)) {
                Node overwriteNode;
                Node depNode = aggregated.adoptNode(dep.getNode().cloneNode(true));
                String licenseName = ToolUtils.findFirstChildByPath(depNode, "licenses/license/name").map(ToolUtils::textFromNode).orElse("");
                if ((licenseName.isEmpty() || "unknown".equalsIgnoreCase(licenseName)) && (overwriteNode = this.overwriteArtifacts.get(dep.getArtifact())) != null) {
                    if (this.verbose) {
                        System.out.printf("Overwriting license information for \"%s\"%n", dep.getArtifact());
                    }
                    ToolUtils.findFirstChildByTagName(depNode, "licenses").ifPresent(depNode::removeChild);
                    ToolUtils.findFirstChildByTagName(overwriteNode, "licenses").ifPresent(node -> depNode.appendChild(aggregated.adoptNode(node.cloneNode(true))));
                }
                children.add(depNode);
            }
        }
        children.forEach(aggregatedDependencies::appendChild);
        ToolUtils.printDocument(aggregated, os);
    }

    void loadOverwriteXML(String fileName) throws IOException, SAXException {
        System.out.printf("Loading XML with overwrites from \"%s\"%n", fileName);
        Document doc = this.docBuilder.parse(new File(fileName));
        if (doc == this.emptyDocument) {
            System.err.printf("File \"%s\" is empty!%n", fileName);
        }
        ToolUtils.parseXMLDependencies(doc).forEach(deo -> {
            this.overwriteArtifacts.put(deo.getArtifact(), deo.getNode());
            if (this.verbose) {
                System.out.printf("Found artifact %s to overwrite.%n", deo.getArtifact());
            }
        });
    }

    private void setVerbose() {
        this.verbose = true;
    }

    private void loadLicenseFromXML(String fileName) throws Exception {
        System.out.printf("Loading licenses from XML \"%s\"%n", fileName);
        this.licensesDoc = this.docBuilder.parse(new File(fileName));
        if (this.licensesDoc == this.emptyDocument) {
            System.err.printf("File \"%s\" is empty!%n", fileName);
        }
    }
}

