/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan8;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.util.Util;
import org.infinispan.tools.store.migrator.marshaller.common.AdvancedExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ExternalizerTable;

class ArrayExternalizers {
    ArrayExternalizers() {
    }

    public static class ListArray
    implements AdvancedExternalizer<List[]> {
        @Override
        public void writeObject(ObjectOutput output, List[] lists) throws IOException {
            UnsignedNumeric.writeUnsignedInt((DataOutput)output, (int)lists.length);
            for (List l : lists) {
                output.writeObject(l);
            }
        }

        @Override
        public List[] readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int len = UnsignedNumeric.readUnsignedInt((DataInput)input);
            List[] lists = new List[len];
            for (int i = 0; i < len; ++i) {
                lists[i] = (List)input.readObject();
            }
            return lists;
        }

        @Override
        public Integer getId() {
            return ExternalizerTable.LIST_ARRAY;
        }

        @Override
        public Set getTypeClasses() {
            return Util.asSet((Object[])new Class[]{List[].class});
        }
    }
}

