/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan8;

import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.jboss.marshalling.commons.StreamingMarshaller;
import org.infinispan.tools.store.migrator.marshaller.common.AdvancedExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.ByteBufferImplExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.EmbeddedMetadataExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.EnumSetExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.ImmortalCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.ImmortalCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.ImmutableMapWrapperExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.InternalMetadataImplExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.KeyValuePairExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MapExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MarshalledEntryImpl;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataImmortalCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataImmortalCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataMortalCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataMortalCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataTransientCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataTransientCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataTransientMortalCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MetadataTransientMortalCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MortalCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.MortalCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.NumericVersionExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.SimpleClusteredVersionExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.TransientCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.TransientCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.TransientMortalCacheEntryExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.TransientMortalCacheValueExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ArrayExternalizers;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ImmutableListCopyExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ListExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.SetExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.SingletonListExternalizer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

class ExternalizerTable
implements ObjectTable {
    private static final Map<Integer, Integer> LEGACY_MAP = Map.ofEntries(Map.entry(2, 1), Map.entry(10, 7), Map.entry(11, 8), Map.entry(12, 9), Map.entry(13, 10), Map.entry(14, 11), Map.entry(15, 12), Map.entry(16, 13), Map.entry(17, 14), Map.entry(19, 105), Map.entry(76, 38), Map.entry(77, 39), Map.entry(78, 40), Map.entry(79, 41), Map.entry(80, 42), Map.entry(81, 43), Map.entry(82, 44), Map.entry(83, 45), Map.entry(96, 55), Map.entry(98, 57), Map.entry(99, 58), Map.entry(103, 60), Map.entry(105, 62), Map.entry(106, 106), Map.entry(121, 63));
    static int ARRAY_LIST = 0;
    static int JDK_SETS = 3;
    static int SINGLETON_LIST = 4;
    static int IMMUTABLE_LIST = 18;
    static int INTERNAL_METADATA = 104;
    static int LIST_ARRAY = 122;
    private static final Log log = LogFactory.getLog(ExternalizerTable.class);
    private static final int MAX_ID = 255;
    private final Map<Integer, ExternalizerAdapter> readers = new HashMap<Integer, ExternalizerAdapter>();
    private final StreamingMarshaller marshaller;

    ExternalizerTable(StreamingMarshaller marshaller, Map<Integer, ? extends AdvancedExternalizer> externalizerMap) {
        this.marshaller = marshaller;
        this.loadInternalMarshallables();
        this.initForeignMarshallables(externalizerMap);
    }

    public ObjectTable.Writer getObjectWriter(Object o) {
        return null;
    }

    public Object readObject(Unmarshaller input) throws IOException, ClassNotFoundException {
        int readerIndex = input.readUnsignedByte();
        int foreignId = -1;
        if (readerIndex == 255) {
            foreignId = UnsignedNumeric.readUnsignedInt((DataInput)input);
            readerIndex = this.generateForeignReaderIndex(foreignId);
        } else {
            Integer legacyId = LEGACY_MAP.get(readerIndex);
            if (legacyId != null) {
                readerIndex = legacyId;
            }
        }
        ExternalizerAdapter adapter = this.readers.get(readerIndex);
        if (adapter == null) {
            if (foreignId > 0) {
                throw log.missingForeignExternalizer(foreignId);
            }
            throw log.unknownExternalizerReaderIndex(readerIndex);
        }
        return adapter.externalizer.readObject((ObjectInput)input);
    }

    private void loadInternalMarshallables() {
        this.addInternalExternalizer(new ListExternalizer());
        this.addInternalExternalizer(new MapExternalizer());
        this.addInternalExternalizer(new SetExternalizer());
        this.addInternalExternalizer(new EnumSetExternalizer());
        this.addInternalExternalizer(new ArrayExternalizers.ListArray());
        this.addInternalExternalizer(new SingletonListExternalizer());
        this.addInternalExternalizer(new ImmutableListCopyExternalizer());
        this.addInternalExternalizer(new ImmutableMapWrapperExternalizer());
        this.addInternalExternalizer(new ByteBufferImplExternalizer());
        this.addInternalExternalizer(new NumericVersionExternalizer());
        this.addInternalExternalizer(new KeyValuePairExternalizer());
        this.addInternalExternalizer(new InternalMetadataImplExternalizer(INTERNAL_METADATA));
        this.addInternalExternalizer(new MarshalledEntryImpl.Externalizer((Marshaller)this.marshaller));
        this.addInternalExternalizer(new ImmortalCacheEntryExternalizer());
        this.addInternalExternalizer(new MortalCacheEntryExternalizer());
        this.addInternalExternalizer(new TransientCacheEntryExternalizer());
        this.addInternalExternalizer(new TransientMortalCacheEntryExternalizer());
        this.addInternalExternalizer(new ImmortalCacheValueExternalizer());
        this.addInternalExternalizer(new MortalCacheValueExternalizer());
        this.addInternalExternalizer(new TransientCacheValueExternalizer());
        this.addInternalExternalizer(new TransientMortalCacheValueExternalizer());
        this.addInternalExternalizer(new SimpleClusteredVersionExternalizer());
        this.addInternalExternalizer(new MetadataImmortalCacheEntryExternalizer());
        this.addInternalExternalizer(new MetadataMortalCacheEntryExternalizer());
        this.addInternalExternalizer(new MetadataTransientCacheEntryExternalizer());
        this.addInternalExternalizer(new MetadataTransientMortalCacheEntryExternalizer());
        this.addInternalExternalizer(new MetadataImmortalCacheValueExternalizer());
        this.addInternalExternalizer(new MetadataMortalCacheValueExternalizer());
        this.addInternalExternalizer(new MetadataTransientCacheValueExternalizer());
        this.addInternalExternalizer(new MetadataTransientMortalCacheValueExternalizer());
        this.addInternalExternalizer(new EmbeddedMetadataExternalizer());
    }

    private void addInternalExternalizer(AdvancedExternalizer ext) {
        int id = this.checkInternalIdLimit(ext.getId(), ext);
        this.updateExtReadersWithTypes(new ExternalizerAdapter(id, ext));
    }

    private void updateExtReadersWithTypes(ExternalizerAdapter adapter) {
        this.updateExtReadersWithTypes(adapter, adapter.id);
    }

    private void updateExtReadersWithTypes(ExternalizerAdapter adapter, int readerIndex) {
        Set typeClasses = adapter.externalizer.getTypeClasses();
        if (!typeClasses.isEmpty()) {
            for (Class typeClass : typeClasses) {
                this.updateExtReaders(adapter, typeClass, readerIndex);
            }
        } else {
            throw log.advanceExternalizerTypeClassesUndefined(adapter.externalizer.getClass().getName());
        }
    }

    private void initForeignMarshallables(Map<Integer, ? extends AdvancedExternalizer> externalizerMap) {
        for (Map.Entry<Integer, ? extends AdvancedExternalizer> entry : externalizerMap.entrySet()) {
            AdvancedExternalizer ext = entry.getValue();
            Integer id = ext.getId();
            if (entry.getKey() == null && id == null) {
                throw new CacheConfigurationException(String.format("No advanced externalizer identifier set for externalizer %s", ext.getClass().getName()));
            }
            if (entry.getKey() != null) {
                id = entry.getKey();
            }
            id = this.checkForeignIdLimit(id, ext);
            this.updateExtReadersWithTypes(new ExternalizerAdapter(id, ext), this.generateForeignReaderIndex(id));
        }
    }

    private void updateExtReaders(ExternalizerAdapter adapter, Class<?> typeClass, int readerIndex) {
        ExternalizerAdapter prevReader = this.readers.put(readerIndex, adapter);
        if (prevReader != null && !prevReader.equals(adapter)) {
            throw log.duplicateExternalizerIdFound(adapter.id, typeClass, prevReader.externalizer.getClass().getName(), readerIndex);
        }
    }

    private int checkInternalIdLimit(int id, AdvancedExternalizer ext) {
        if (id >= 255) {
            String msg = String.format("Internal %s externalizer is using an id(%d) that exceeded the limit. It needs to be smaller than %d", ext.getClass().getSimpleName(), id, 255);
            throw new CacheConfigurationException(msg);
        }
        return id;
    }

    private int checkForeignIdLimit(int id, AdvancedExternalizer ext) {
        if (id < 0) {
            String msg = String.format("Foreign %s externalizer is using a negative id(%d). Only positive id values are allowed.", ext.getClass().getSimpleName(), id);
            throw new CacheConfigurationException(msg);
        }
        return id;
    }

    private int generateForeignReaderIndex(int foreignId) {
        return Integer.MIN_VALUE | foreignId;
    }

    private static class ExternalizerAdapter {
        final int id;
        final AdvancedExternalizer externalizer;

        ExternalizerAdapter(int id, AdvancedExternalizer externalizer) {
            this.id = id;
            this.externalizer = externalizer;
        }

        public String toString() {
            return this.externalizer.getClass().getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalizerAdapter that = (ExternalizerAdapter)o;
            if (this.id != that.id) {
                return false;
            }
            return !(this.externalizer != null ? this.externalizer.getClass() != that.externalizer.getClass() : that.externalizer != null);
        }

        public int hashCode() {
            int result = this.id;
            result = 31 * result + (this.externalizer.getClass() != null ? this.externalizer.getClass().hashCode() : 0);
            return result;
        }
    }
}

