/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.Version;
import org.infinispan.tools.store.migrator.Element;
import org.infinispan.tools.store.migrator.StoreType;

public class StoreProperties {
    private final Element root;
    private final Properties properties;
    private final StoreType storeType;
    private final String cacheName;
    private final int majorVersion;

    public StoreProperties(StoreProperties properties) {
        this.root = properties.root;
        this.storeType = properties.storeType;
        this.cacheName = properties.cacheName();
        this.majorVersion = properties.majorVersion();
        Properties clone = new Properties(properties.properties.size());
        clone.putAll((Map<?, ?>)properties.properties);
        this.properties = clone;
    }

    public StoreProperties(Element root, Properties properties) {
        this.root = root;
        this.properties = properties;
        this.validate();
        this.storeType = StoreType.valueOf(this.get(Element.TYPE).toUpperCase());
        this.cacheName = this.get(Element.CACHE_NAME);
        this.majorVersion = this.majorVersion();
    }

    private int majorVersion() {
        String version = this.get(Element.VERSION);
        if (version != null) {
            return Integer.parseInt(version);
        }
        return Integer.parseInt(Version.getMajor());
    }

    public boolean isTargetStore() {
        return this.root == Element.TARGET;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public boolean isCurrentMajorVersion() {
        return Integer.parseInt(Version.getMajor()) == this.majorVersion;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public StoreType storeType() {
        return this.storeType;
    }

    public boolean isSegmented() {
        String segmentCount = this.get(Element.SEGMENT_COUNT);
        if (segmentCount == null) {
            return false;
        }
        return Integer.parseInt(segmentCount) > 0;
    }

    public void put(String value, Element ... elements) {
        this.properties.put(this.key(elements), value);
    }

    public String get(Element ... elements) {
        return this.properties.getProperty(this.key(elements));
    }

    public String key(Element ... elements) {
        StringBuilder sb = new StringBuilder(this.root.toString().toLowerCase());
        sb.append(".");
        for (int i = 0; i < elements.length; ++i) {
            sb.append(elements[i].toString());
            if (i == elements.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public void required(String ... required) {
        for (String prop : required) {
            if (this.properties.get(prop) != null) continue;
            String msg = String.format("The property %s must be specified.", prop);
            throw new CacheConfigurationException(msg);
        }
    }

    public void required(Element ... required) {
        for (Element prop : required) {
            if (this.properties.get(this.key(prop)) != null) continue;
            String msg = String.format("The property '%s' must be specified.", this.key(prop));
            throw new CacheConfigurationException(msg);
        }
    }

    private void validate() {
        this.required(Element.TYPE);
        this.required(Element.CACHE_NAME);
        if (this.get(Element.MARSHALLER, Element.TYPE) != null) {
            throw new CacheConfigurationException(String.format("Property '%s' has been removed, please specify %s instead.", this.key(Element.MARSHALLER, Element.TYPE), this.key(Element.VERSION)));
        }
    }
}

