/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan9;

import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.tools.store.migrator.marshaller.common.AbstractUnsupportedStreamingMarshaller;
import org.infinispan.tools.store.migrator.marshaller.common.AdvancedExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.Externalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.BytesObjectInput;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.ExternalJbossMarshaller;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.ExternalizerTable;
import org.infinispan.tools.store.migrator.marshaller.infinispan9.Primitives;

public class Infinispan9Marshaller
extends AbstractUnsupportedStreamingMarshaller {
    private static final int ID_NULL = 0;
    private static final int ID_PRIMITIVE = 1;
    private static final int ID_INTERNAL = 2;
    private static final int ID_EXTERNAL = 3;
    private static final int ID_ANNOTATED = 4;
    private static final int ID_UNKNOWN = 5;
    private static final int ID_ARRAY = 6;
    private static final int ID_CLASS = 7;
    private static final int TYPE_MASK = 7;
    private static final int ARRAY_SIZE_MASK = 192;
    private static final int FLAG_SINGLE_TYPE = 8;
    private static final int FLAG_COMPONENT_TYPE_MATCH = 16;
    private static final int FLAG_ALL_NULL = 32;
    private static final int FLAG_ARRAY_EMPTY = 0;
    private static final int FLAG_ARRAY_SMALL = 64;
    private static final int FLAG_ARRAY_MEDIUM = 128;
    private static final int FLAG_ARRAY_LARGE = 192;
    private final ExternalJbossMarshaller external;
    private final Map<Integer, AdvancedExternalizer> exts = ExternalizerTable.getInternalExternalizers((Marshaller)this);

    public Infinispan9Marshaller(Map<Integer, AdvancedExternalizer> userExts) {
        this.exts.putAll(userExts);
        this.external = new ExternalJbossMarshaller(this);
    }

    @Override
    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        return this.readNullableObject(new BytesObjectInput(buf, offset, this));
    }

    <T> Externalizer<T> findExternalizerIn(ObjectInput in) throws IOException {
        int type = in.readUnsignedByte();
        switch (type) {
            case 2: {
                return this.exts.get(in.readUnsignedByte());
            }
            case 3: {
                return this.exts.get(in.readInt());
            }
        }
        return null;
    }

    Object readNullableObject(BytesObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readUnsignedByte();
        if (type == 0) {
            return null;
        }
        switch (type) {
            case 1: {
                return Primitives.readPrimitive(in);
            }
            case 2: {
                return this.exts.get(in.readUnsignedByte()).readObject(in);
            }
            case 3: {
                return this.exts.get(in.readInt()).readObject(in);
            }
            case 4: {
                return this.readAnnotated(in);
            }
            case 5: {
                return this.external.objectFromObjectStream(in);
            }
            case 6: {
                return this.readArray(in);
            }
        }
        throw new IOException("Unknown type: " + type);
    }

    private Object readAnnotated(BytesObjectInput in) throws IOException, ClassNotFoundException {
        Class clazz = (Class)in.readObject();
        try {
            Externalizer ext = (Externalizer)clazz.newInstance();
            return ext.readObject(in);
        }
        catch (Exception e) {
            throw new CacheException("Error instantiating class: " + String.valueOf(clazz), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object readArray(BytesObjectInput in) throws IOException, ClassNotFoundException {
        boolean componentTypeMatch;
        Class<?> componentType;
        byte flags = in.readByte();
        int type = flags & 7;
        AdvancedExternalizer componentExt = null;
        Class extClazz = null;
        switch (type) {
            case 0: 
            case 1: 
            case 6: {
                throw new IOException("Unexpected component type: " + type);
            }
            case 2: {
                componentExt = this.exts.get(in.readByte());
                componentType = this.getOrReadClass(in, componentExt);
                break;
            }
            case 3: {
                componentExt = this.exts.get(in.readInt());
                componentType = this.getOrReadClass(in, componentExt);
                break;
            }
            case 4: {
                extClazz = (Class)in.readObject();
            }
            case 5: {
                componentType = (Class<?>)in.readObject();
                break;
            }
            case 7: {
                componentType = this.getClass(in.readByte());
                break;
            }
            default: {
                throw new IOException("Unknown component type: " + type);
            }
        }
        int maskedSize = flags & 0xC0;
        int length = switch (maskedSize) {
            case 0 -> 0;
            case 64 -> in.readUnsignedByte() + 1;
            case 128 -> in.readUnsignedShort() + 257;
            case 192 -> in.readInt();
            default -> throw new IOException("Unknown array size: " + maskedSize);
        };
        Object array = Array.newInstance(componentType, length);
        if ((flags & 0x20) != 0) {
            return array;
        }
        boolean singleType = (flags & 8) != 0;
        boolean bl = componentTypeMatch = (flags & 0x10) != 0;
        assert (!componentTypeMatch || singleType);
        if (singleType) {
            Externalizer<?> ext;
            if (componentTypeMatch) {
                ext = this.getArrayElementExternalizer(type, componentExt, extClazz);
            } else {
                type = in.readByte();
                ext = this.readExternalizer(in, type);
            }
            if (ext != null) {
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, ext.readObject(in));
                }
                return array;
            } else {
                switch (type) {
                    case 5: {
                        int i = 0;
                        while (true) {
                            if (i >= length) {
                                return array;
                            }
                            Array.set(array, i, this.external.objectFromObjectStream(in));
                            ++i;
                        }
                    }
                    case 1: {
                        byte primitiveId = in.readByte();
                        int i = 0;
                        while (i < length) {
                            Array.set(array, i, Primitives.readRawPrimitive(in, primitiveId));
                            ++i;
                        }
                        return array;
                    }
                }
                throw new IllegalStateException();
            }
        }
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, this.readNullableObject(in));
        }
        return array;
    }

    private Class<?> getClass(int id) throws IOException {
        switch (id) {
            case 0: {
                return Object.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return List.class;
            }
            case 3: {
                return Map.Entry.class;
            }
            case 16: {
                return InternalCacheValue.class;
            }
        }
        throw new IOException("Unknown class id " + id);
    }

    private Externalizer<?> getArrayElementExternalizer(int type, AdvancedExternalizer<?> componentExt, Class<?> extClazz) throws IOException {
        switch (type) {
            case 2: 
            case 3: {
                return componentExt;
            }
            case 4: {
                try {
                    return (Externalizer)extClazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("Error instantiating class: " + String.valueOf(extClazz), (Throwable)e);
                }
            }
            case 5: {
                return null;
            }
        }
        throw new IOException("Unexpected component type: " + type);
    }

    private Externalizer<?> readExternalizer(BytesObjectInput in, int type) throws ClassNotFoundException, IOException {
        switch (type) {
            case 2: {
                return this.exts.get(0xFF & in.readByte());
            }
            case 3: {
                return this.exts.get(in.readInt());
            }
            case 4: {
                Class extClazz = (Class)in.readObject();
                try {
                    return (Externalizer)extClazz.newInstance();
                }
                catch (Exception e) {
                    throw new CacheException("Error instantiating class: " + String.valueOf(extClazz), (Throwable)e);
                }
            }
            case 1: 
            case 5: {
                return null;
            }
        }
        throw new IOException("Unexpected component type: " + type);
    }

    private Class<?> getOrReadClass(BytesObjectInput in, AdvancedExternalizer<?> componentExt) throws ClassNotFoundException, IOException {
        if (componentExt.getTypeClasses().size() == 1) {
            return componentExt.getTypeClasses().iterator().next();
        }
        return (Class)in.readObject();
    }
}

