/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.tools.store.migrator.marshaller.common.AbstractMigratorExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.Ids;

public class EmbeddedMetadataExternalizer
extends AbstractMigratorExternalizer<EmbeddedMetadata> {
    private static final int IMMORTAL = 0;
    private static final int EXPIRABLE = 1;
    private static final int LIFESPAN_EXPIRABLE = 2;
    private static final int MAXIDLE_EXPIRABLE = 3;
    private final Map<Class<?>, Integer> numbers = new HashMap(4);

    public EmbeddedMetadataExternalizer() {
        super(Set.of(EmbeddedMetadata.class, EmbeddedMetadata.EmbeddedExpirableMetadata.class, EmbeddedMetadata.EmbeddedLifespanExpirableMetadata.class, EmbeddedMetadata.EmbeddedMaxIdleExpirableMetadata.class), Ids.EMBEDDED_METADATA);
        this.numbers.put(EmbeddedMetadata.class, 0);
        this.numbers.put(EmbeddedMetadata.EmbeddedExpirableMetadata.class, 1);
        this.numbers.put(EmbeddedMetadata.EmbeddedLifespanExpirableMetadata.class, 2);
        this.numbers.put(EmbeddedMetadata.EmbeddedMaxIdleExpirableMetadata.class, 3);
    }

    @Override
    public EmbeddedMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte number = input.readByte();
        EmbeddedMetadata.Builder builder = new EmbeddedMetadata.Builder();
        switch (number) {
            case 0: {
                builder.version((EntryVersion)input.readObject());
                break;
            }
            case 1: {
                builder.lifespan(EmbeddedMetadataExternalizer.toMillis(input.readLong(), TimeUnit.MILLISECONDS)).maxIdle(EmbeddedMetadataExternalizer.toMillis(input.readLong(), TimeUnit.MILLISECONDS)).version((EntryVersion)input.readObject());
                break;
            }
            case 2: {
                builder.lifespan(EmbeddedMetadataExternalizer.toMillis(input.readLong(), TimeUnit.MILLISECONDS)).version((EntryVersion)input.readObject());
                break;
            }
            case 3: {
                builder.maxIdle(EmbeddedMetadataExternalizer.toMillis(input.readLong(), TimeUnit.MILLISECONDS)).version((EntryVersion)input.readObject());
            }
            default: {
                throw new IllegalStateException("Unknown metadata type " + number);
            }
        }
        return (EmbeddedMetadata)builder.build();
    }

    private static long toMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? -1L : timeUnit.toMillis(duration);
    }
}

