/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.marshall.core.Ids;

public class TransientCacheValueExternalizer
implements AdvancedExternalizer<TransientCacheValue> {
    public Set<Class<? extends TransientCacheValue>> getTypeClasses() {
        return Collections.singleton(TransientCacheValue.class);
    }

    public Integer getId() {
        return Ids.TRANSIENT_VALUE;
    }

    public void writeObject(ObjectOutput output, TransientCacheValue icv) throws IOException {
        output.writeObject(icv.getValue());
        UnsignedNumeric.writeUnsignedLong((DataOutput)output, (long)icv.getLastUsed());
        output.writeLong(icv.getMaxIdle());
    }

    public TransientCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Object value = input.readObject();
        long lastUsed = UnsignedNumeric.readUnsignedLong((DataInput)input);
        long maxIdle = input.readLong();
        return new TransientCacheValue(value, maxIdle, lastUsed);
    }
}

