/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tasks.manager.impl;

import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.manager.TaskExecution;

@ProtoTypeId(value=4806)
public class TaskExecutionImpl
implements TaskExecution {
    @ProtoField(value=1)
    final UUID uuid;
    @ProtoField(value=2)
    final String name;
    @ProtoField(value=3)
    final String what;
    @ProtoField(value=4)
    final String where;
    @ProtoField(value=5)
    final String who;
    Instant start;

    @ProtoFactory
    TaskExecutionImpl(UUID uuid, String name, String what, String where, String who) {
        this.uuid = uuid;
        this.name = name;
        this.what = what;
        this.where = where;
        this.who = who;
    }

    public TaskExecutionImpl(String name, String where, String who, TaskContext context) {
        this.uuid = Util.threadLocalRandomUUID();
        this.name = name;
        this.where = where;
        this.who = who;
        this.what = context.getCache().isPresent() ? ((Cache)context.getCache().get()).getName() : null;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Instant getStart() {
        return this.start;
    }

    @Override
    public Optional<String> getWhat() {
        return Optional.ofNullable(this.what);
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    @Override
    public Optional<String> getWho() {
        return Optional.ofNullable(this.who);
    }

    public void setStart(Instant start) {
        this.start = start;
    }
}

