/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import org.infinispan.client.hotrod.RemoteCache;

public class RemoteInfinispanCacheMeterBinder<K, V>
extends CacheMeterBinder<RemoteCache<K, V>> {
    public RemoteInfinispanCacheMeterBinder(RemoteCache<K, V> cache, Iterable<Tag> tags) {
        super(cache, cache.getName(), tags);
    }

    protected Long size() {
        return null;
    }

    protected long hitCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return ((RemoteCache)this.getCache()).clientStatistics().getRemoteHits();
    }

    protected Long missCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return ((RemoteCache)this.getCache()).clientStatistics().getRemoteMisses();
    }

    protected Long evictionCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return ((RemoteCache)this.getCache()).clientStatistics().getRemoteRemoves();
    }

    protected long putCount() {
        if (this.getCache() == null) {
            return 0L;
        }
        return ((RemoteCache)this.getCache()).clientStatistics().getRemoteStores();
    }

    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        if (this.getCache() == null) {
            return;
        }
        Gauge.builder((String)"cache.reset", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getTimeSinceReset()).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description("Time elapsed in seconds since the last statistics reset").register(registry);
        this.averages(registry);
        this.nearCacheMetrics(registry);
    }

    private void averages(MeterRegistry registry) {
        Gauge.builder((String)"cache.puts.latency", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getAverageRemoteStoreTime()).tags(this.getTagsWithCacheName()).description("Cache puts").register(registry);
        Gauge.builder((String)"cache.gets.latency", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getAverageRemoteReadTime()).tags(this.getTagsWithCacheName()).description("Cache gets").register(registry);
        Gauge.builder((String)"cache.removes.latency", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getAverageRemoteRemovesTime()).tags(this.getTagsWithCacheName()).description("Cache removes").register(registry);
    }

    private void nearCacheMetrics(MeterRegistry registry) {
        if (this.isNearCacheEnabled()) {
            Gauge.builder((String)"cache.near.requests", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getNearCacheHits()).tags(this.getTagsWithCacheName()).tag("result", "hit").description("The number of hits (reads) of near cache entries owned by this client").register(registry);
            Gauge.builder((String)"cache.near.requests", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getNearCacheMisses()).tags(this.getTagsWithCacheName()).tag("result", "miss").description("The number of hits (reads) of near cache entries owned by this client").register(registry);
            Gauge.builder((String)"cache.near.invalidations", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getNearCacheInvalidations()).tags(this.getTagsWithCacheName()).description("The number of invalidations of near cache entries owned by this client").register(registry);
            Gauge.builder((String)"cache.near.size", (Object)((RemoteCache)this.getCache()), cache -> cache.clientStatistics().getNearCacheSize()).tags(this.getTagsWithCacheName()).description("The size of the near cache owned by this client").register(registry);
        }
    }

    private boolean isNearCacheEnabled() {
        return ((RemoteCache)this.getCache()).clientStatistics().getNearCacheSize() > 0L;
    }
}

