/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.spring.starter.remote;

import java.util.Map;
import java.util.Properties;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;

@org.springframework.boot.context.properties.ConfigurationProperties(value="infinispan.remote", ignoreInvalidFields=true)
public class InfinispanRemoteConfigurationProperties
extends ConfigurationProperties {
    public static final String DEFAULT_CLIENT_PROPERTIES = "classpath:hotrod-client.properties";
    private boolean enabled = true;
    private String clientProperties = "classpath:hotrod-client.properties";
    private boolean reactive = false;
    private long readTimeout = 0L;
    private long writeTimeout = 0L;

    public String getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(String clientProperties) {
        this.clientProperties = clientProperties;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        Properties properties = this.getProperties();
        builder.withProperties(properties);
        return builder;
    }

    public void setSaslProperties(Map<String, String> saslProperties) {
        saslProperties.forEach((k, v) -> this.getProperties().setProperty("infinispan.client.hotrod.sasl_properties." + k, (String)v));
    }

    public void setCluster(Map<String, String> cluster) {
        cluster.forEach((k, v) -> this.getProperties().setProperty("infinispan.client.hotrod.cluster." + k, (String)v));
    }

    public boolean isReactive() {
        return this.reactive;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }
}

