/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.net.InetAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.JmxTestClient;
import org.infinispan.server.test.api.MemcachedTestClientDriver;
import org.infinispan.server.test.api.RespTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.api.TestClientDriver;
import org.infinispan.server.test.core.TestClient;
import org.infinispan.server.test.junit4.InfinispanServerRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class InfinispanServerTestMethodRule
implements TestRule,
TestClientDriver {
    private final TestClient testClient;
    private static final AtomicInteger KCOUNTER = new AtomicInteger(0);

    public InfinispanServerTestMethodRule(InfinispanServerRule infinispanServerRule) {
        Objects.requireNonNull(infinispanServerRule, "InfinispanServerRule class Rule is null");
        this.testClient = new TestClient(infinispanServerRule.getTestServer());
    }

    public String getMethodName() {
        return this.testClient.getMethodName();
    }

    public String getMethodName(String qualifier) {
        return this.testClient.getMethodName(new Object[]{qualifier});
    }

    public HotRodTestClientDriver hotrod() {
        return this.testClient.hotrod();
    }

    public RestTestClientDriver rest() {
        return this.testClient.rest();
    }

    public RespTestClientDriver resp() {
        return this.testClient.resp();
    }

    public JmxTestClient jmx() {
        return this.testClient.jmx();
    }

    public MemcachedTestClientDriver memcached() {
        return this.testClient.memcached();
    }

    public CounterManager getCounterManager() {
        return this.testClient.getCounterManager();
    }

    public InetAddress getServerAddress(int offset) {
        return this.testClient.getServerDriver().getServerAddress(offset);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(this){
            final /* synthetic */ InfinispanServerTestMethodRule this$0;
            {
                this.this$0 = this$0;
            }

            public void evaluate() throws Throwable {
                this.this$0.testClient.initResources();
                try {
                    this.this$0.testClient.setMethodName(description.getTestClass().getSimpleName() + "." + description.getMethodName());
                    base.evaluate();
                }
                finally {
                    this.this$0.testClient.clearResources();
                }
            }
        };
    }

    public String addScript(RemoteCacheManager remoteCacheManager, String script) {
        return this.testClient.addScript(remoteCacheManager, script);
    }

    public boolean isContainerized() {
        return false;
    }

    public RestClient newRestClient(RestClientConfigurationBuilder restClientConfigurationBuilder) {
        return this.testClient.newRestClient(restClientConfigurationBuilder);
    }

    public static final String k() {
        return "k-" + KCOUNTER.incrementAndGet();
    }
}

