/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.junit4;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestServer;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.junit.runners.model.Statement;

public class InfinispanServerRule
implements TestRule {
    private static final Log log = LogFactory.getLog(InfinispanServerRule.class);
    private final TestServer testServer;
    protected final List<Consumer<File>> configurationEnhancers = new ArrayList<Consumer<File>>();

    public InfinispanServerRule(InfinispanServerTestConfiguration configuration) {
        this.testServer = new TestServer(configuration);
    }

    public InfinispanServerDriver getServerDriver() {
        return this.testServer.getDriver();
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(this){
            final /* synthetic */ InfinispanServerRule this$0;
            {
                this.this$0 = this$0;
            }

            public void evaluate() throws Throwable {
                String testName = description.getTestClass().getName().replaceAll("\\$", "-");
                RunWith runWith = description.getTestClass().getAnnotation(RunWith.class);
                boolean inSuite = runWith != null && Suite.class.isAssignableFrom(runWith.value());
                boolean hasXsite = this.this$0.testServer.hasCrossSiteEnabled();
                if (!inSuite && !hasXsite) {
                    TestResourceTracker.testStarted((String)testName);
                }
                boolean manageServer = !this.this$0.testServer.isDriverInitialized();
                try {
                    if (manageServer) {
                        this.this$0.testServer.initServerDriver();
                        this.this$0.testServer.getDriver().prepare(testName);
                        this.this$0.testServer.beforeListeners();
                        this.this$0.configurationEnhancers.forEach(c -> c.accept(this.this$0.testServer.getDriver().getConfDir()));
                        this.this$0.testServer.getDriver().start(testName);
                    }
                    this.this$0.before(testName);
                    base.evaluate();
                }
                catch (Throwable e) {
                    log.error((Object)"Problem during the server initialization", e);
                    throw e;
                }
                finally {
                    this.this$0.after(testName);
                    if (manageServer) {
                        if (this.this$0.testServer.isDriverInitialized()) {
                            this.this$0.testServer.stopServerDriver(testName);
                        }
                        this.this$0.testServer.afterListeners();
                    }
                    if (!inSuite && !hasXsite) {
                        TestResourceTracker.testFinished((String)testName);
                    }
                }
            }
        };
    }

    private void before(String name) {
    }

    private void after(String name) {
    }

    public TestServer getTestServer() {
        return this.testServer;
    }

    public static Log getLog() {
        return log;
    }
}

