/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.server.test.core.InfinispanServerListener;
import org.infinispan.server.test.core.ServerRunMode;
import org.jboss.shrinkwrap.api.Archive;

public class InfinispanServerTestConfiguration {
    public static final String LON = "LON";
    public static final String NYC = "NYC";
    private static final Map<String, Integer> SITE_DISCOVER_PORTS_OFFSET = Map.of("LON", 1000, "NYC", 2000);
    private static final int DEFAULT_DISCOVER_PORT = 46655;
    private final String configurationFile;
    private final int numServers;
    private final int expectedServers;
    private final ServerRunMode runMode;
    private final Properties properties;
    private final String[] mavenArtifacts;
    private final Archive<?>[] archives;
    private final boolean jmx;
    private final boolean parallelStartup;
    private final List<InfinispanServerListener> listeners;
    private final boolean defaultFile;
    private final String clusterName;
    private final String site;
    private final int portOffset;
    private final String[] features;
    private final String[] dataFiles;

    public InfinispanServerTestConfiguration(String configurationFile, int numServers, int expectedServers, ServerRunMode runMode, Properties properties, String[] mavenArtifacts, Archive<?>[] archives, boolean jmx, boolean parallelStartup, boolean defaultFile, List<InfinispanServerListener> listeners, String clusterName, String site, int portOffset, String[] features, String[] dataFiles) {
        this.configurationFile = configurationFile;
        this.numServers = numServers;
        this.expectedServers = expectedServers;
        this.runMode = runMode;
        this.properties = properties;
        this.mavenArtifacts = mavenArtifacts;
        this.archives = archives;
        this.jmx = jmx;
        this.parallelStartup = parallelStartup;
        this.defaultFile = defaultFile;
        this.listeners = List.copyOf(listeners);
        this.clusterName = clusterName;
        this.site = site;
        this.portOffset = portOffset;
        this.features = features;
        this.dataFiles = dataFiles;
    }

    public String configurationFile() {
        return this.configurationFile;
    }

    public int numServers() {
        return this.numServers;
    }

    public int expectedServers() {
        return this.expectedServers;
    }

    public ServerRunMode runMode() {
        return this.runMode;
    }

    public Properties properties() {
        return this.properties;
    }

    public Archive<?>[] archives() {
        return this.archives;
    }

    public boolean isJMXEnabled() {
        return this.jmx;
    }

    public String[] mavenArtifacts() {
        return this.mavenArtifacts;
    }

    public boolean isParallelStartup() {
        return this.parallelStartup;
    }

    public boolean isDefaultFile() {
        return this.defaultFile;
    }

    public List<InfinispanServerListener> listeners() {
        return this.listeners;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String site() {
        return this.site;
    }

    public int siteDiscoveryPort() {
        return 46655 + this.sitePortOffset();
    }

    public int sitePortOffset() {
        return SITE_DISCOVER_PORTS_OFFSET.get(this.site);
    }

    public int getPortOffset() {
        return this.portOffset;
    }

    public String[] getFeatures() {
        return this.features;
    }

    public String[] getDataFiles() {
        return this.dataFiles;
    }
}

