/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.api;

import java.util.EnumSet;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.Self;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.server.test.api.CommonTestClientDriver;
import org.infinispan.server.test.api.TestUser;

abstract class AbstractTestClientDriver<S extends AbstractTestClientDriver<S>>
implements Self<S>,
CommonTestClientDriver<S> {
    protected BasicConfiguration serverConfiguration = null;
    protected EnumSet<CacheContainerAdmin.AdminFlag> flags = EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class);
    protected CacheMode mode = null;
    protected TestUser user;
    protected AuthorizationPermission userPerm;
    protected Object[] qualifiers;

    AbstractTestClientDriver() {
    }

    static StringConfiguration forCacheMode(CacheMode mode) {
        return switch (mode) {
            case CacheMode.LOCAL -> DefaultTemplate.LOCAL.getConfiguration();
            case CacheMode.DIST_ASYNC -> DefaultTemplate.DIST_ASYNC.getConfiguration();
            case CacheMode.DIST_SYNC -> DefaultTemplate.DIST_SYNC.getConfiguration();
            case CacheMode.REPL_ASYNC -> DefaultTemplate.REPL_ASYNC.getConfiguration();
            case CacheMode.REPL_SYNC -> DefaultTemplate.REPL_SYNC.getConfiguration();
            default -> throw new IllegalArgumentException(mode.toString());
        };
    }

    @Override
    public S withServerConfiguration(ConfigurationBuilder serverConfiguration) {
        if (this.mode != null) {
            throw new IllegalStateException("Cannot set server configuration and cache mode");
        }
        this.serverConfiguration = serverConfiguration.build();
        return (S)((AbstractTestClientDriver)this.self());
    }

    @Override
    public S withServerConfiguration(StringConfiguration configuration) {
        if (this.mode != null) {
            throw new IllegalStateException("Cannot set server configuration and cache mode");
        }
        this.serverConfiguration = configuration;
        return (S)((AbstractTestClientDriver)this.self());
    }

    @Override
    public S withCacheMode(CacheMode mode) {
        if (this.serverConfiguration != null) {
            throw new IllegalStateException("Cannot set server configuration and cache mode");
        }
        this.mode = mode;
        return (S)((AbstractTestClientDriver)this.self());
    }

    @Override
    public S withUser(TestUser testUser) {
        if (this.userPerm != null) {
            throw new IllegalStateException("Both TestUser and AuthorizationPermission cannot be set!");
        }
        this.user = testUser;
        return (S)((AbstractTestClientDriver)this.self());
    }

    @Override
    public S withUser(AuthorizationPermission permission) {
        if (this.user != null) {
            throw new IllegalStateException("Both TestUser and AuthorizationPermission cannot be set!");
        }
        this.userPerm = permission;
        return (S)((AbstractTestClientDriver)this.self());
    }

    @Override
    public S withQualifiers(Object ... qualifiers) {
        this.qualifiers = qualifiers;
        return (S)((AbstractTestClientDriver)this.self());
    }

    public S makeVolatile() {
        this.flags = EnumSet.of(CacheContainerAdmin.AdminFlag.VOLATILE);
        return (S)((AbstractTestClientDriver)this.self());
    }
}

