/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core.rollingupgrade;

import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.api.TestUser;
import org.infinispan.server.test.core.ContainerInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.ServerConfigBuilder;
import org.infinispan.server.test.core.ServerRunMode;
import org.infinispan.server.test.core.rollingupgrade.RollingUpgradeConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RollingUpgradeHandler {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final RollingUpgradeConfiguration configuration;
    private String toImageCreated;
    private String fromImageCreated;
    private ContainerInfinispanServerDriver fromDriver;
    private ContainerInfinispanServerDriver toDriver;
    private RemoteCacheManager remoteCacheManager;
    private RedisClusterClient respClient;
    private MemcachedClient[] memcachedClients;
    private RestClient[] restClients;
    private STATE currentState = STATE.NOT_STARTED;

    private RollingUpgradeHandler(RollingUpgradeConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getToImageCreated() {
        return this.toImageCreated;
    }

    public String getFromImageCreated() {
        return this.fromImageCreated;
    }

    public ContainerInfinispanServerDriver getFromDriver() {
        return this.fromDriver;
    }

    public ContainerInfinispanServerDriver getToDriver() {
        return this.toDriver;
    }

    public RollingUpgradeConfiguration getConfiguration() {
        return this.configuration;
    }

    public RemoteCacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }

    public RestClient rest(int server, RestClientConfigurationBuilder builder) {
        if (this.restClients[server] != null) {
            return this.restClients[server];
        }
        InetAddress address = this.getCurrentState() == STATE.OLD_RUNNING ? this.fromDriver.getServerAddress(server) : this.toDriver.getServerAddress(server);
        builder.addServer().host(address.getHostAddress()).port(11222);
        this.restClients[server] = RestClient.forConfiguration((RestClientConfiguration)builder.build());
        return this.restClients[server];
    }

    public RedisClusterClient resp(RedisURI.Builder builder) {
        if (this.respClient != null) {
            return this.respClient;
        }
        int nodeCount = this.configuration.nodeCount();
        Function<Integer, InetAddress> addressFunction = i -> this.fromDriver.isRunning((int)i) ? this.fromDriver.getServerAddress((int)i) : this.toDriver.getServerAddress((int)i);
        ArrayList<RedisURI> uris = new ArrayList<RedisURI>();
        for (int i2 = 0; i2 < nodeCount; ++i2) {
            InetAddress address = addressFunction.apply(i2);
            RedisURI uri = builder.withHost(address.getHostAddress()).withPort(11222).withTimeout(Duration.ofSeconds(30L)).build();
            uris.add(uri);
        }
        this.respClient = RedisClusterClient.create(uris);
        return this.respClient;
    }

    public MemcachedClient memcached(int server, ConnectionFactoryBuilder builder) {
        if (this.memcachedClients[server] != null) {
            return this.memcachedClients[server];
        }
        InetAddress address = this.getCurrentState() == STATE.OLD_RUNNING ? this.fromDriver.getServerAddress(server) : this.toDriver.getServerAddress(server);
        try {
            this.memcachedClients[server] = new MemcachedClient(builder.build(), Collections.singletonList(InetSocketAddress.createUnresolved(address.getHostAddress(), 11222)));
            return this.memcachedClients[server];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public STATE getCurrentState() {
        return this.currentState;
    }

    public static void performUpgrade(RollingUpgradeConfiguration configuration) throws InterruptedException {
        String site1Name = "site1";
        RollingUpgradeHandler handler = new RollingUpgradeHandler(configuration);
        int nodeCount = configuration.nodeCount();
        String versionFrom = configuration.fromVersion();
        String versionTo = configuration.toVersion();
        try {
            log.debugf("Starting %d node to version %s", nodeCount, (Object)versionFrom);
            handler.fromDriver = handler.startNode(false, configuration.nodeCount(), configuration.nodeCount(), site1Name, configuration.jgroupsProtocol(), null);
            handler.currentState = STATE.OLD_RUNNING;
            try (RemoteCacheManager manager = handler.createRemoteCacheManager();){
                handler.remoteCacheManager = manager;
                handler.restClients = new RestClient[nodeCount];
                handler.memcachedClients = new MemcachedClient[nodeCount];
                configuration.initialHandler().accept(handler);
                for (int i = 0; i < nodeCount; ++i) {
                    log.debugf("Shutting down 1 node from version: %s", (Object)versionFrom);
                    int nodeId = nodeCount - i - 1;
                    String volumeId = handler.fromDriver.volumeId(nodeId);
                    handler.fromDriver.stop(nodeId);
                    handler.cleanup(i);
                    handler.currentState = STATE.REMOVED_OLD;
                    if (!RollingUpgradeHandler.ensureServersWorking(handler, nodeCount - 1)) {
                        if (log.isDebugEnabled()) {
                            log.debugf("Servers are: %s", (Object)Arrays.toString(manager.getServers()));
                        }
                        throw new IllegalStateException("Servers did not shut down properly within 30 seconds, assuming error");
                    }
                    log.debugf("Starting 1 node to version %s", (Object)versionTo);
                    if (handler.toDriver == null) {
                        handler.toDriver = handler.startNode(true, 1, nodeCount, site1Name, configuration.jgroupsProtocol(), volumeId);
                    } else {
                        handler.toDriver.startAdditionalServer(nodeCount, volumeId);
                    }
                    handler.currentState = STATE.ADDED_NEW;
                    if (RollingUpgradeHandler.ensureServersWorking(handler, nodeCount)) continue;
                    if (log.isDebugEnabled()) {
                        log.debugf("Servers are only: %s", (Object)Arrays.toString(manager.getServers()));
                    }
                    throw new IllegalStateException("Servers did not cluster within 30 seconds, assuming error");
                }
                handler.currentState = STATE.NEW_RUNNING;
            }
        }
        catch (Throwable t) {
            handler.currentState = STATE.ERROR;
            handler.configuration.exceptionHandler().accept(t, handler);
            throw t;
        }
        finally {
            handler.cleanup();
        }
    }

    private static boolean ensureServersWorking(RollingUpgradeHandler handler, int expectedCount) throws InterruptedException {
        long begin = System.nanoTime();
        while (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - begin) < (long)handler.configuration.serverCheckTimeSecs()) {
            log.debugf("Checking to ensure cluster formed properly, expecting %d servers", expectedCount);
            if (handler.configuration.isValidServerState().test(handler)) {
                return true;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        }
        log.debugf("Cluster state check timed out after %d secs, check for possible issues", handler.configuration.serverCheckTimeSecs());
        return false;
    }

    private void cleanup() {
        if (this.fromDriver != null) {
            this.fromDriver.stop(this.configuration.fromVersion());
        }
        if (this.toDriver != null) {
            this.toDriver.stop(this.configuration.toVersion());
        }
        Arrays.stream(this.restClients).forEach(Util::close);
        Arrays.stream(this.memcachedClients).forEach(c -> {
            if (c != null) {
                c.shutdown();
            }
        });
        Util.close((AutoCloseable)this.respClient);
    }

    private void cleanup(int server) {
        Util.close((AutoCloseable)this.restClients[server]);
        this.restClients[server] = null;
        if (this.memcachedClients[server] != null) {
            this.memcachedClients[server].shutdown();
            this.memcachedClients[server] = null;
        }
    }

    public RemoteCacheManager createRemoteCacheManager() {
        TestUser user = TestUser.ADMIN;
        String hotrodURI = "hotrod://" + user.getUser() + ":" + user.getPassword() + "@" + this.fromDriver.getServerAddress(0).getHostAddress() + ":11222";
        log.debugf("Creating RCM with uri: %s", (Object)hotrodURI);
        return new RemoteCacheManager(hotrodURI);
    }

    private ContainerInfinispanServerDriver startNode(boolean toOrFrom, int nodeCount, int expectedCount, String clusterName, String protocol, String volumeId) {
        String versionToUse;
        ServerConfigBuilder builder = new ServerConfigBuilder("infinispan.xml", true);
        builder.runMode(ServerRunMode.CONTAINER);
        builder.numServers(nodeCount);
        builder.expectedServers(expectedCount);
        builder.clusterName(clusterName);
        builder.property("infinispan.cluster.stack", protocol);
        builder.property("org.infinispan.test.server.requireJoinTimeout", Boolean.toString(nodeCount != expectedCount));
        if (this.configuration.useSharedDataMount()) {
            builder.property("org.infinispan.test.server.container.volume", "true");
        }
        String string = versionToUse = toOrFrom ? this.configuration.toVersion() : this.configuration.fromVersion();
        if (versionToUse.startsWith("image://")) {
            builder.property("org.infinispan.test.server.container.baseImageName", versionToUse.substring("image://".length()));
        } else if (versionToUse.startsWith("file://")) {
            String imageName;
            builder.property("org.infinispan.test.server.dir", versionToUse.substring("file://".length()));
            versionToUse = Path.of(versionToUse, new String[0]).getFileName().toString();
            if (toOrFrom) {
                assert (this.toImageCreated == null);
                this.toImageCreated = versionToUse.toLowerCase() + "-to";
                imageName = this.toImageCreated;
            } else {
                assert (this.fromImageCreated == null);
                this.fromImageCreated = versionToUse.toLowerCase() + "-from";
                imageName = this.fromImageCreated;
            }
            builder.property("org.infinispan.test.server.container.snapshotImageName", imageName);
        } else {
            builder.property("org.infinispan.test.server.version", versionToUse);
        }
        InfinispanServerTestConfiguration config = builder.createServerTestConfiguration();
        ContainerInfinispanServerDriver driver = (ContainerInfinispanServerDriver)ServerRunMode.CONTAINER.newDriver(config);
        driver.prepare(versionToUse);
        if (volumeId != null) {
            if (nodeCount != 1) {
                throw new IllegalArgumentException("nodeCount " + nodeCount + " must be 1 when a volumeId is passed " + volumeId);
            }
            driver.configureImage(versionToUse);
            driver.startAdditionalServer(expectedCount, volumeId);
        } else {
            driver.start(versionToUse);
        }
        return driver;
    }

    public static enum STATE {
        NOT_STARTED,
        OLD_RUNNING,
        REMOVED_OLD,
        ADDED_NEW,
        NEW_RUNNING,
        ERROR;

    }
}

