/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCacheManagerFactory;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.server.test.api.HotRodTestClientDriver;
import org.infinispan.server.test.api.JmxTestClient;
import org.infinispan.server.test.api.MemcachedTestClientDriver;
import org.infinispan.server.test.api.RespTestClientDriver;
import org.infinispan.server.test.api.RestTestClientDriver;
import org.infinispan.server.test.core.InfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.server.test.core.TestServer;

public class TestClient {
    protected InfinispanServerTestConfiguration configuration;
    protected TestServer testServer;
    protected List<AutoCloseable> resources;
    protected Map<String, RemoteCacheManager> hotrodCacheMap;
    protected Map<String, RestClient> restCacheMap;
    private String methodName;

    public TestClient(TestServer testServer) {
        this.testServer = testServer;
    }

    public <T extends AutoCloseable> T registerResource(T resource) {
        this.resources.add(resource);
        return resource;
    }

    public void registerHotRodCache(String name, RemoteCacheManager remoteCacheManager) {
        this.hotrodCacheMap.put(name, remoteCacheManager);
    }

    public void registerRestCache(String name, RestClient restClient) {
        this.restCacheMap.put(name, restClient);
    }

    public InfinispanServerDriver getServerDriver() {
        if (!this.testServer.isDriverInitialized()) {
            throw new IllegalStateException("Operation not supported before test starts");
        }
        return this.testServer.getDriver();
    }

    public HotRodTestClientDriver hotrod() {
        return new HotRodTestClientDriver(this.testServer, this);
    }

    public RestTestClientDriver rest() {
        return new RestTestClientDriver(this.testServer, this);
    }

    public RespTestClientDriver resp() {
        return new RespTestClientDriver(this.testServer, this);
    }

    public MemcachedTestClientDriver memcached() {
        return new MemcachedTestClientDriver(this.testServer, this);
    }

    public JmxTestClient jmx() {
        return new JmxTestClient(this.testServer, this);
    }

    public CounterManager getCounterManager() {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.testServer.newHotRodClient());
        return RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)remoteCacheManager);
    }

    public <K, V> MultimapCacheManager<K, V> getRemoteMultimapCacheManager() {
        RemoteCacheManager remoteCacheManager = this.registerResource(this.testServer.newHotRodClient());
        return RemoteMultimapCacheManagerFactory.from((RemoteCacheManager)remoteCacheManager);
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void clearResources() {
        if (this.hotrodCacheMap != null) {
            this.hotrodCacheMap.forEach((n, rcm) -> rcm.administration().removeCache(n));
            this.hotrodCacheMap.clear();
        }
        if (this.restCacheMap != null) {
            this.restCacheMap.forEach((n, rc) -> rc.cache(n).delete());
            this.restCacheMap.clear();
        }
        if (this.resources != null) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                CompletableFuture.allOf((CompletableFuture[])this.resources.stream().map(resource -> CompletableFuture.runAsync(() -> Util.close((AutoCloseable)resource), executor)).toArray(CompletableFuture[]::new)).get(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Unable to close resources for " + this.methodName, e);
            }
            finally {
                this.resources.clear();
                executor.shutdown();
            }
        }
    }

    public void initResources() {
        this.resources = new ArrayList<AutoCloseable>();
        this.hotrodCacheMap = new HashMap<String, RemoteCacheManager>();
        this.restCacheMap = new HashMap<String, RestClient>();
    }

    public String addScript(RemoteCacheManager remoteCacheManager, String script) {
        RemoteCache scriptCache = remoteCacheManager.getCache("___script_cache");
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(script);){
            scriptCache.put((Object)this.getMethodName(), (Object)CommonsTestingUtil.loadFileAsString((InputStream)in));
        }
        catch (HotRodClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.getMethodName();
    }

    public RestClient newRestClient(RestClientConfigurationBuilder restClientConfigurationBuilder) {
        RestClient restClient = this.testServer.newRestClient(restClientConfigurationBuilder);
        this.registerResource(restClient);
        return restClient;
    }

    public MemcachedClient getMemcachedClient(ConnectionFactoryBuilder builder) {
        TestServer.CloseableMemcachedClient memcachedClient = this.testServer.newMemcachedClient(builder);
        return this.registerResource(memcachedClient).getClient();
    }

    public String getMethodName() {
        return this.getMethodName(new Object[]{null});
    }

    public String getMethodName(Object ... qualifiers) {
        StringBuilder sb = new StringBuilder("C").append(this.methodName);
        if (qualifiers != null) {
            for (Object q : qualifiers) {
                if (q == null) continue;
                sb.append(q);
            }
        }
        String cacheName = sb.toString();
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            byte[] digest = sha1.digest(cacheName.getBytes(StandardCharsets.UTF_8));
            return Util.toHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

