/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.File;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.configuration.RestClientConfiguration;
import org.infinispan.client.rest.configuration.RestClientConfigurationBuilder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.Util;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.ForkedServer;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;

public class ForkedInfinispanServerDriver
extends AbstractInfinispanServerDriver {
    private static final Log log = LogFactory.getLog(ForkedInfinispanServerDriver.class);
    private final List<ForkedServer> forkedServers = new ArrayList<ForkedServer>();

    protected ForkedInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, InetAddress.getLoopbackAddress());
    }

    @Override
    public void prepare(String name) {
    }

    @Override
    protected void start(String name, File rootDir, File configurationFile) {
        String allServerHomes = this.configuration.properties().getProperty("org.infinispan.test.server.home");
        if (allServerHomes == null) {
            throw new IllegalArgumentException("You must specify a org.infinispan.test.server.home property pointing to a comma-separated list of server homes.");
        }
        String[] serverHomes = allServerHomes.replaceAll("\\s+", "").split(",");
        if (serverHomes.length != this.configuration.numServers()) {
            throw new IllegalArgumentException("configuration.numServers should be the same as the number of servers declared on org.infinispan.test.server");
        }
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            ForkedServer server = new ForkedServer(serverHomes[i]).setServerConfiguration(configurationFile.getPath()).setPortsOffset(i);
            this.copyArtifactsToUserLibDir(server.getServerLib());
            this.forkedServers.add(server.start());
            this.forkedServers.get(0).printServerLog(arg_0 -> ((Log)log).info(arg_0));
        }
    }

    @Override
    protected void stop() {
        try {
            ForkedInfinispanServerDriver.sync(this.getRestClient(0).cluster().stop());
        }
        catch (Exception e) {
            log.error((Object)"Could not gracefully shutdown the cluster. Killing the servers.", (Throwable)e);
            for (int i = 0; i < this.configuration.numServers(); ++i) {
                this.kill(i);
            }
        }
    }

    @Override
    public void stop(int server) {
        ForkedInfinispanServerDriver.sync(this.getRestClient(server).server().stop());
    }

    @Override
    public boolean isRunning(int server) {
        try {
            ForkedInfinispanServerDriver.sync(this.getRestClient(server).server().configuration());
        }
        catch (RuntimeException r) {
            return !(Util.getRootCause((Throwable)r) instanceof ConnectException);
        }
        return true;
    }

    @Override
    public InetSocketAddress getServerSocket(int server, int port) {
        return new InetSocketAddress(this.getServerAddress(server), this.getServerPort(server, port));
    }

    @Override
    public InetAddress getServerAddress(int server) {
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName("localhost"));
    }

    @Override
    public void pause(int server) {
        Exceptions.unchecked(() -> new ProcessBuilder("kill -SIGSTOP " + this.forkedServers.get(server).getPid()).start().waitFor(10L, TimeUnit.SECONDS));
    }

    @Override
    public void resume(int server) {
        Exceptions.unchecked(() -> new ProcessBuilder("kill -SIGCONT " + this.forkedServers.get(server).getPid()).start().waitFor(10L, TimeUnit.SECONDS));
    }

    @Override
    public void kill(int server) {
        Exceptions.unchecked(() -> new ProcessBuilder("kill -9 " + this.forkedServers.get(server).getPid()).start().waitFor(10L, TimeUnit.SECONDS));
    }

    @Override
    public void restart(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restartCluster() {
        throw new UnsupportedOperationException();
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server) {
        return null;
    }

    @Override
    public int getTimeout() {
        return ForkedServer.TIMEOUT_SECONDS;
    }

    private RestClient getRestClient(int server) {
        RestClientConfigurationBuilder builder = new RestClientConfigurationBuilder();
        builder.addServer().host("localhost").port(this.getServerPort(server, ForkedServer.DEFAULT_SINGLE_PORT));
        return RestClient.forConfiguration((RestClientConfiguration)builder.build());
    }

    private int getServerPort(int server, int port) {
        return server == 0 ? port : 100 * server + port;
    }

    private static <T> T sync(CompletionStage<T> stage) {
        return (T)Exceptions.unchecked(() -> stage.toCompletableFuture().get(5L, TimeUnit.SECONDS));
    }
}

