/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.test.core;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.management.MBeanServerConnection;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.ExitStatus;
import org.infinispan.server.Server;
import org.infinispan.server.test.core.AbstractInfinispanServerDriver;
import org.infinispan.server.test.core.InfinispanServerTestConfiguration;
import org.infinispan.test.TestingUtil;

public class EmbeddedInfinispanServerDriver
extends AbstractInfinispanServerDriver {
    public static final int OFFSET_FACTOR = 100;
    private static final int TIMEOUT_SECONDS = Integer.getInteger("org.infinispan.test.server.embedded.timeoutSeconds", 30);
    List<Server> servers;
    List<CompletableFuture<ExitStatus>> serverFutures;

    protected EmbeddedInfinispanServerDriver(InfinispanServerTestConfiguration configuration) {
        super(configuration, InetAddress.getLoopbackAddress());
    }

    protected int clusterPortOffset() {
        if (this.configuration.site() != null) {
            this.configuration.sitePortOffset();
        }
        return this.configuration.site() == null ? this.configuration.getPortOffset() : this.configuration.sitePortOffset();
    }

    @Override
    protected void start(String name, File rootDir, File configurationFile) {
        this.servers = new ArrayList<Server>();
        this.serverFutures = new ArrayList<CompletableFuture<ExitStatus>>();
        for (int i = 0; i < this.configuration.numServers(); ++i) {
            File serverRoot = EmbeddedInfinispanServerDriver.createServerHierarchy(rootDir, Integer.toString(i));
            Properties properties = new Properties();
            properties.setProperty("infinispan.server.home.path", serverRoot.getAbsolutePath());
            properties.setProperty("infinispan.server.config.path", new File(rootDir, "conf").getAbsolutePath());
            properties.setProperty("infinispan.socket.binding.port-offset", Integer.toString(this.clusterPortOffset() + i * 100));
            properties.setProperty("infinispan.cluster.name", name);
            properties.setProperty("infinispan.cluster.stack", System.getProperty("infinispan.cluster.stack"));
            properties.setProperty("org.infinispan.test.host.address", this.testHostAddress.getHostName());
            this.configureSite(properties);
            this.configuration.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put(k, StringPropertyReplacer.replaceProperties((String)((String)v), (Properties)properties))));
            Server server2 = new Server(serverRoot, new File(configurationFile.getName()), properties);
            server2.setExitHandler((ExitHandler)new DefaultExitHandler());
            this.serverFutures.add(server2.run());
            this.servers.add(server2);
        }
        List<CacheContainer> cacheManagers = this.servers.stream().map(server -> (DefaultCacheManager)server.getCacheManagers().values().iterator().next()).collect(Collectors.toList());
        if (cacheManagers.size() > 1) {
            TestingUtil.blockUntilViewsReceived((long)TimeUnit.SECONDS.toMillis(TIMEOUT_SECONDS), (CacheContainer[])cacheManagers.toArray(new CacheContainer[0]));
        }
    }

    @Override
    protected void stop() {
        RuntimeException aggregate = new RuntimeException();
        if (this.servers != null) {
            for (int i = 0; i < this.servers.size(); ++i) {
                Server server = this.servers.get(i);
                server.getExitHandler().exit(ExitStatus.SERVER_SHUTDOWN);
                try {
                    this.serverFutures.get(i).get();
                    continue;
                }
                catch (Throwable t) {
                    aggregate.addSuppressed(t);
                }
            }
            if (aggregate.getSuppressed().length > 0) {
                throw aggregate;
            }
        }
    }

    @Override
    public InetSocketAddress getServerSocket(int server, int port) {
        return new InetSocketAddress(this.getServerAddress(server), port + this.clusterPortOffset() + server * 100);
    }

    @Override
    public InetAddress getServerAddress(int server) {
        return (InetAddress)Exceptions.unchecked(() -> InetAddress.getByName("localhost"));
    }

    @Override
    public void pause(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resume(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void kill(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restart(int server) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restartCluster() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRunning(int server) {
        return this.servers.get(server).getStatus().allowInvocations();
    }

    @Override
    public MBeanServerConnection getJmxConnection(int server) {
        DefaultCacheManager cacheManager = (DefaultCacheManager)this.servers.get(server).getCacheManagers().values().iterator().next();
        return cacheManager.getCacheManagerConfiguration().jmx().mbeanServerLookup().getMBeanServer();
    }

    @Override
    public int getTimeout() {
        return TIMEOUT_SECONDS;
    }

    private void configureSite(Properties properties) {
        if (this.configuration.site() == null) {
            return;
        }
        properties.setProperty("relay.site_name", this.configuration.site());
        properties.setProperty("jgroups.cluster.mcast_port", Integer.toString(this.configuration.siteDiscoveryPort()));
        properties.setProperty("jgroups.tcp.port", Integer.toString(7800 + this.clusterPortOffset()));
    }
}

