/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.security.GeneralSecurityException;
import java.security.Permission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.Attribute;
import org.infinispan.server.configuration.Element;
import org.infinispan.server.configuration.security.RealmProvider;
import org.infinispan.server.configuration.security.SSLConfiguration;
import org.infinispan.server.configuration.security.SecurityConfiguration;
import org.infinispan.server.configuration.security.ServerIdentitiesConfiguration;
import org.infinispan.server.configuration.security.TrustStoreRealmConfiguration;
import org.infinispan.server.security.ServerSecurityRealm;
import org.infinispan.server.security.realm.CachingModifiableSecurityRealm;
import org.infinispan.server.security.realm.CachingSecurityRealm;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.cache.LRURealmIdentityCache;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.ssl.SSLContextBuilder;

public class RealmConfiguration
extends ConfigurationElement<RealmConfiguration> {
    static final AttributeDefinition<String> NAME = AttributeDefinition.builder((Enum)Attribute.NAME, null, String.class).build();
    static final AttributeDefinition<String> DEFAULT_REALM = AttributeDefinition.builder((Enum)Attribute.DEFAULT_REALM, null, String.class).immutable().build();
    static final AttributeDefinition<Integer> CACHE_MAX_SIZE = AttributeDefinition.builder((Enum)Attribute.CACHE_MAX_SIZE, (Object)256).build();
    static final AttributeDefinition<TimeQuantity> CACHE_LIFESPAN = AttributeDefinition.builder((Enum)Attribute.CACHE_LIFESPAN, (Object)TimeQuantity.valueOf((String)"1m")).build();
    static final AttributeDefinition<EvidenceDecoder> EVIDENCE_DECODER = AttributeDefinition.builder((Enum)Attribute.EVIDENCE_DECODER, null, EvidenceDecoder.class).immutable().build();
    private final EnumSet<ServerSecurityRealm.Feature> features = EnumSet.noneOf(ServerSecurityRealm.Feature.class);
    Map<String, SecurityRealm> realms;
    private final ServerIdentitiesConfiguration serverIdentitiesConfiguration;
    private final List<RealmProvider> realmProviders;
    private Supplier<Boolean> httpChallengeReadiness = () -> true;
    private ServerSecurityRealm serverSecurityRealm;
    private RealmIdentityCache cache;
    private SSLContext serverSslContext = null;
    private SSLContext clientSslContext = null;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RealmConfiguration.class, new AttributeDefinition[]{NAME, DEFAULT_REALM, CACHE_MAX_SIZE, CACHE_LIFESPAN, EVIDENCE_DECODER});
    }

    RealmConfiguration(AttributeSet attributes, ServerIdentitiesConfiguration serverIdentitiesConfiguration, List<RealmProvider> realmConfigurations) {
        super((Enum)Element.SECURITY_REALM, attributes, (ConfigurationElement[])realmConfigurations.stream().map(p -> (ConfigurationElement)p).toArray(ConfigurationElement[]::new));
        this.serverIdentitiesConfiguration = serverIdentitiesConfiguration;
        this.realmProviders = realmConfigurations;
    }

    public ServerIdentitiesConfiguration serverIdentitiesConfiguration() {
        return this.serverIdentitiesConfiguration;
    }

    public List<RealmProvider> realmProviders() {
        return this.realmProviders;
    }

    public Map<String, SecurityRealm> realms() {
        return this.realms;
    }

    public String name() {
        return (String)this.attributes.attribute(NAME).get();
    }

    public String toString() {
        return "RealmConfiguration{attributes=" + String.valueOf(this.attributes) + ", serverIdentitiesConfiguration=" + String.valueOf(this.serverIdentitiesConfiguration) + ", realmsConfiguration=" + String.valueOf(this.realmProviders) + "}";
    }

    public ServerSecurityRealm serverSecurityRealm() {
        if (this.serverSecurityRealm == null) {
            throw new IllegalStateException();
        }
        return this.serverSecurityRealm;
    }

    public SSLContext serverSSLContext() {
        if (this.serverSslContext == null) {
            throw Server.log.noSSLContext(this.name());
        }
        return this.serverSslContext;
    }

    public SSLContext clientSSLContext() {
        if (this.clientSslContext == null) {
            throw Server.log.noSSLContext(this.name());
        }
        return this.clientSslContext;
    }

    public boolean hasServerSSLContext() {
        return this.serverSslContext != null;
    }

    public boolean hasClientSSLContext() {
        return this.clientSslContext != null;
    }

    void init(SecurityConfiguration security, Properties properties) {
        SSLConfiguration sslConfiguration = this.serverIdentitiesConfiguration.sslConfiguration();
        SSLContextBuilder sslContextBuilder = sslConfiguration != null ? sslConfiguration.build(properties, this.features) : null;
        SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
        this.attributes.attribute(EVIDENCE_DECODER).apply(arg_0 -> ((SecurityDomain.Builder)domainBuilder).setEvidenceDecoder(arg_0));
        domainBuilder.setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        if (this.realmProviders.isEmpty() || !(this.realmProviders.get(0) instanceof TrustStoreRealmConfiguration)) {
            this.buildSSLContexts(sslContextBuilder);
        }
        this.realms = new HashMap<String, SecurityRealm>(this.realmProviders.size());
        for (RealmProvider provider : this.realmProviders) {
            SecurityRealm realm = provider.build(security, this, domainBuilder, properties);
            provider.applyFeatures(this.features);
            this.realms.put(provider.name(), realm);
            if (realm == null) continue;
            domainBuilder.addRealm(provider.name(), this.cacheable(realm)).build();
            if (domainBuilder.getDefaultRealmName() != null) continue;
            domainBuilder.setDefaultRealmName(provider.name());
        }
        SecurityDomain securityDomain = domainBuilder.build();
        if (this.features.contains((Object)ServerSecurityRealm.Feature.TRUST)) {
            sslContextBuilder.setSecurityDomain(securityDomain);
            this.buildSSLContexts(sslContextBuilder);
        }
        String name = (String)this.attributes.attribute(NAME).get();
        this.serverSecurityRealm = new ServerSecurityRealm(name, securityDomain, this.httpChallengeReadiness, this.serverIdentitiesConfiguration, this.features);
    }

    private void buildSSLContexts(SSLContextBuilder sslContextBuilder) {
        try {
            if (sslContextBuilder != null) {
                this.serverSslContext = (SSLContext)sslContextBuilder.setClientMode(false).build().create();
                this.clientSslContext = (SSLContext)sslContextBuilder.setClientMode(true).build().create();
            }
        }
        catch (GeneralSecurityException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private SecurityRealm cacheable(SecurityRealm realm) {
        int maxEntries = (Integer)this.attributes.attribute(CACHE_MAX_SIZE).get();
        if (maxEntries > 0 && realm instanceof CacheableSecurityRealm) {
            if (this.cache == null) {
                this.cache = new LRURealmIdentityCache(maxEntries, ((TimeQuantity)this.attributes.attribute(CACHE_LIFESPAN).get()).longValue());
            }
            if (realm instanceof ModifiableSecurityRealm) {
                return new CachingModifiableSecurityRealm((CacheableSecurityRealm)realm, this.cache);
            }
            return new CachingSecurityRealm((CacheableSecurityRealm)realm, this.cache);
        }
        return realm;
    }

    public boolean hasFeature(ServerSecurityRealm.Feature feature) {
        return this.features.contains((Object)feature);
    }

    void setHttpChallengeReadiness(Supplier<Boolean> httpChallengeReadiness) {
        this.httpChallengeReadiness = httpChallengeReadiness;
    }

    public void flushCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }
}

