/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.memcached;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    MEMCACHED_CONNECTOR,
    AUTHENTICATION,
    ENCRYPTION,
    SASL;

    private static final Map<String, Element> ELEMENTS;
    private final String name;

    private Element(String name) {
        this.name = name;
    }

    private Element() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public static Element forName(String localName) {
        Element element = ELEMENTS.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.name;
            if (name == null) continue;
            map.put(name, element);
        }
        ELEMENTS = map;
    }
}

