/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.configuration.Element;
import org.wildfly.security.credential.source.CredentialSource;

public class KerberosSecurityFactoryConfiguration
implements ConfigurationInfo {
    private static final String[] DEFAULT_MECHANISM_NAMES = new String[]{"KRB5", "SPNEGO"};
    static final AttributeDefinition<String> PRINCIPAL = AttributeDefinition.builder((String)"principal", null, String.class).build();
    static final AttributeDefinition<String> KEYTAB_PATH = AttributeDefinition.builder((String)"keytabPath", null, String.class).build();
    static final AttributeDefinition<String> RELATIVE_TO = AttributeDefinition.builder((String)"relativeTo", null, String.class).build();
    static final AttributeDefinition<Boolean> DEBUG = AttributeDefinition.builder((String)"debug", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Long> FAIL_CACHE = AttributeDefinition.builder((String)"failCache", (Object)0L, Long.class).build();
    static final AttributeDefinition<Set<String>> MECHANISM_NAMES = AttributeDefinition.builder((String)"mechanismNames", new HashSet()).initializer(() -> new HashSet<String>(Arrays.asList(DEFAULT_MECHANISM_NAMES))).build();
    static final AttributeDefinition<Set<String>> MECHANISM_OIDS = AttributeDefinition.builder((String)"mechanismOids", new HashSet()).initializer(HashSet::new).build();
    static final AttributeDefinition<Integer> MINIMUM_REMAINING_LIFETIME = AttributeDefinition.builder((String)"minimumRemainingLifetime", (Object)0, Integer.class).build();
    static final AttributeDefinition<Boolean> OBTAIN_KERBEROS_TICKET = AttributeDefinition.builder((String)"obtainKerberosTicket", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Map<String, Object>> OPTIONS = AttributeDefinition.builder((String)"options", new HashMap()).initializer(HashMap::new).build();
    static final AttributeDefinition<Integer> REQUEST_LIFETIME = AttributeDefinition.builder((String)"requiredLifetime", (Object)0, Integer.class).build();
    static final AttributeDefinition<Boolean> REQUIRED = AttributeDefinition.builder((String)"required", (Object)false, Boolean.class).build();
    static final AttributeDefinition<Boolean> SERVER = AttributeDefinition.builder((String)"server", (Object)true, Boolean.class).build();
    static final AttributeDefinition<Boolean> WRAP_GSS_CREDENTIAL = AttributeDefinition.builder((String)"wrapGssCredential", (Object)false, Boolean.class).build();
    private static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.KERBEROS.toString());
    private final AttributeSet attributes;
    private final CredentialSource credentialSource;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(KerberosSecurityFactoryConfiguration.class, new AttributeDefinition[]{PRINCIPAL, KEYTAB_PATH, RELATIVE_TO, DEBUG, FAIL_CACHE, MECHANISM_NAMES, MECHANISM_OIDS, MINIMUM_REMAINING_LIFETIME, OBTAIN_KERBEROS_TICKET, OPTIONS, REQUEST_LIFETIME, REQUIRED, SERVER, WRAP_GSS_CREDENTIAL});
    }

    KerberosSecurityFactoryConfiguration(AttributeSet attributes, CredentialSource credentialSource) {
        this.attributes = attributes.checkProtection();
        this.credentialSource = credentialSource;
    }

    public String getPrincipal() {
        return (String)this.attributes.attribute(PRINCIPAL).get();
    }

    public CredentialSource getCredentialSource() {
        return this.credentialSource;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

