/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.hotrod;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.HotRodRouterConfiguration;
import org.infinispan.server.router.logging.Log;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.router.impl.hotrod.handlers.SniHandlerInitializer;

public class HotRodEndpointRouter
implements EndpointRouter {
    private static final String THREAD_NAME_PREFIX = "EndpointRouter";
    private final NioEventLoopGroup masterGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("EndpointRouter-ServerMaster"));
    private final NioEventLoopGroup workerGroup = new NioEventLoopGroup(0, (ThreadFactory)new DefaultThreadFactory("EndpointRouter-ServerWorker"));
    private final HotRodRouterConfiguration configuration;
    private Integer port = null;
    private InetAddress ip = null;

    public HotRodEndpointRouter(HotRodRouterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void start(RoutingTable routingTable, EmbeddedCacheManager ecm) {
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)this.masterGroup, (EventLoopGroup)this.workerGroup).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)this.configuration.tcpNoDelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.configuration.tcpKeepAlive()).childHandler((ChannelHandler)new SniHandlerInitializer(routingTable)).channel(NioServerSocketChannel.class);
            if (this.configuration.sendBufferSize() > 0) {
                bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.configuration.sendBufferSize());
            }
            if (this.configuration.receiveBufferSize() > 0) {
                bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.configuration.receiveBufferSize());
            }
            InetAddress ip = this.configuration.getIp();
            int port = this.configuration.getPort();
            Channel channel = bootstrap.bind(ip, port).sync().channel();
            InetSocketAddress localAddress = (InetSocketAddress)channel.localAddress();
            this.port = localAddress.getPort();
            this.ip = localAddress.getAddress();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw Log.SERVER.hotrodRouterStartFailed(e);
        }
        Log.SERVER.debugf("Hot Rod EndpointRouter listening on %s:%d", this.ip, this.port);
    }

    @Override
    public void stop() {
        Future masterGroupShutdown = this.masterGroup.shutdownGracefully();
        Future workerGroupShutdown = this.workerGroup.shutdownGracefully();
        try {
            masterGroupShutdown.get();
            workerGroupShutdown.get();
        }
        catch (Exception e) {
            Log.SERVER.errorWhileShuttingDown(e);
        }
        this.port = null;
        this.ip = null;
    }

    @Override
    public String getHost() {
        return this.ip.getHostAddress();
    }

    @Override
    public InetAddress getIp() {
        return this.ip;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public EndpointRouter.Protocol getProtocol() {
        return EndpointRouter.Protocol.HOT_ROD;
    }
}

