/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.NoSuchElementException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RegistrationException;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="ISPN")
@ValidIdRange(min=12001, max=13000)
public interface Log
extends BasicLogger {
    public static final Log REST = (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)"org.infinispan.REST");

    public static Log getLog(Class<?> clazz) {
        return (Log)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), Log.class, (String)clazz.getName());
    }

    @Message(value="Unsupported configuration option", id=12004)
    public UnsupportedOperationException unsupportedConfigurationOption();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="An error occurred while responding to the client", id=12005)
    public void errorWhileResponding(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Uncaught exception in the pipeline", id=12006)
    public void uncaughtExceptionInThePipeline(@Cause Throwable var1);

    @Message(value="Cannot convert to %s", id=12007)
    public UnacceptableDataFormatException unsupportedDataFormat(String var1);

    @Message(value="Cache with name '%s' is temporarily unavailable.", id=12008)
    public ServiceUnavailableException cacheUnavailable(String var1);

    @Message(value="Cannot obtain cache '%s', without required MediaType", id=12009)
    public NullPointerException missingRequiredMediaType(String var1);

    @Message(value="Cache with name '%s' not found amongst the configured caches", id=12010)
    public NoCacheFoundException cacheNotFound(String var1);

    @Message(value="Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", id=12011)
    public CacheUnavailableException requestNotAllowedToInternalCaches(String var1);

    @Message(value="Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'", id=12012)
    public CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(String var1);

    @Message(value="Illegal compression level '%d'. The value must be >= 0 and <= 9", id=12014)
    public CacheConfigurationException illegalCompressionLevel(int var1);

    @Message(value="Cannot register invocation '%s': resource already registered for method '%s' at the destination path '/%s'", id=12015)
    public RegistrationException duplicateResourceMethod(String var1, Method var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Header '%s' will be ignored, expecting a number but got '%s'", id=12016)
    public void warnInvalidNumber(String var1, String var2);

    @Message(value="Cannot enable authentication without an authenticator", id=12017)
    public CacheConfigurationException authenticationWithoutAuthenticator();

    @Message(value="Cannot register invocation with path '%s': '*' is only allowed at the end", id=12018)
    public RegistrationException invalidPath(String var1);

    @Message(value="Cannot register path '%s' for invocation '%s', since it conflicts with resource '%s'", id=12019)
    public RegistrationException duplicateResource(String var1, Invocation var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="MassIndexer started", id=12020)
    public void asyncMassIndexerStarted();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="MassIndexer completed successfully", id=12021)
    public void asyncMassIndexerSuccess();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error executing MassIndexer", id=12022)
    public void errorExecutingMassIndexer(@Cause Throwable var1);

    @Message(value="Argument '%s' has illegal value '%s'", id=12023)
    public IllegalArgumentException illegalArgument(String var1, Object var2);

    @Message(value="Synchronized %d entries", id=12024)
    public String synchronizedEntries(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring invalid origin '%s' when reading '-D%s'", id=12025)
    public void invalidOrigin(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="The REST invocation [%s] has been deprecated. Please consult the upgrade guide", id=12026)
    public void warnDeprecatedCall(String var1);

    @Message(value="Security authorization is not enabled on this server.", id=12027)
    public IllegalArgumentException authorizationNotEnabled();

    @Message(value="The principal-role mapper is not mutable", id=12028)
    public String principalRoleMapperNotMutable();

    @Message(value="The role-permission mapper is not mutable", id=12029)
    public String rolePermissionMapperNotMutable();

    @Message(value="Heap dump generation failed", id=12030)
    public RuntimeException heapDumpFailed(@Cause IOException var1);

    @Message(value="Method requires content", id=12031)
    public IllegalArgumentException missingContent();

    @Message(value="Wrong media type '%s'. Expecting '%s'", id=12032)
    public IllegalArgumentException wrongMediaType(String var1, String var2);

    @Message(value="Wrong content: expecting multipart/form-data with two parts", id=12033)
    public IllegalArgumentException cacheCompareWrongContent();

    @Message(value="Wrong method '%s'", id=12034)
    public IllegalArgumentException wrongMethod(String var1);

    @Message(value="Attribute '%s' is immutable", id=12035)
    public IllegalArgumentException immutableAttribute(String var1);

    @Message(value="More than one remote store detected, rolling upgrades aren't supported", id=12036)
    public IllegalStateException multipleRemoteStores();

    @Message(value="Unknown action '%s'", id=12037)
    public IllegalArgumentException unknownAction(String var1);

    @Message(value="'%s' must be a directory", id=12038)
    public IllegalArgumentException notADirectory(String var1);

    @Message(value="Restore failed", id=12039)
    public IllegalStateException restoreFailed();

    @Message(value="Missing required argument '%s'", id=12040)
    public IllegalArgumentException missingArgument(String var1);

    @Message(value="Backup delete failed", id=12041)
    public IllegalStateException backupDeleteFailed();

    @Message(value="Backup failed", id=12042)
    public IllegalStateException backupFailed();

    @Message(value="Invalid request content", id=12043)
    public IllegalArgumentException invalidContent();

    @Message(value="Missing at least one argument in '%s'", id=12044)
    public IllegalArgumentException missingArguments(String ... var1);

    @Message(value="Cache '%s' is not indexed", id=12045)
    public IllegalArgumentException cacheNotIndexed(String var1);

    @Message(value="Cache '%s' does not have statistics enabled", id=12046)
    public IllegalArgumentException statisticsNotEnabled(String var1);

    @Message(value="Site operation on '%s' failed: '%s'", id=12047)
    public IllegalStateException siteOperationFailed(String var1, String var2);

    @Message(value="No such script '%s'", id=12048)
    public NoSuchElementException noSuchScript(String var1);

    @Message(value="Role already exists", id=12049)
    public String roleAlreadyExists();

    @Message(value="Predefined roles are not mutable", id=12050)
    public String predefinedRolesAreNotMutable();

    @Message(value="Argument '%s' is required", id=12051)
    public IllegalArgumentException argumentMissing(String var1);
}

