/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;

public class HealthCheckResource
implements ResourceHandler {
    private final InvocationHelper helper;

    public HealthCheckResource(InvocationHelper helper) {
        this.helper = helper;
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET, Method.HEAD).anonymous(true).path("/health/live").requireCacheManagerStart(false).handleWith(this::notifyServerRunning).invocation().methods(Method.GET, Method.HEAD).anonymous(true).path("/health/ready").requireCacheManagerStart(false).handleWith(this::verifyServerReady).create();
    }

    public CompletionStage<RestResponse> notifyServerRunning(RestRequest request) {
        NettyRestResponse.Builder builder = this.helper.newResponse(request);
        return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.OK).build());
    }

    public CompletionStage<RestResponse> verifyServerReady(RestRequest request) {
        NettyRestResponse.Builder builder = this.helper.newResponse(request);
        DefaultCacheManager dcm = this.helper.getServer().getCacheManager();
        HttpResponseStatus status = HttpResponseStatus.SERVICE_UNAVAILABLE;
        if (dcm.getStatus().allowInvocations() && this.helper.getProtocolServer().isStarted()) {
            status = HttpResponseStatus.OK;
            CacheManagerInfo cmi = dcm.getCacheManagerInfo();
            if (cmi.allCachesStopped()) {
                status = HttpResponseStatus.SERVICE_UNAVAILABLE;
            }
        }
        return CompletableFuture.completedFuture(builder.status(status).build());
    }
}

