/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.distribution;

import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.CacheManagerInfo;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.rest.distribution.NodeDataDistribution;
import org.infinispan.stats.ContainerStats;

@Immutable
@ProtoTypeId(value=6001)
public class NodeDistributionInfo
implements JsonSerialization,
NodeDataDistribution {
    private final String name;
    private final List<String> addresses;
    private final long memoryAvailable;
    private final long memoryUsed;

    @ProtoFactory
    public NodeDistributionInfo(String name, List<String> addresses, long memoryAvailable, long memoryUsed) {
        this.name = name;
        this.addresses = addresses;
        this.memoryAvailable = memoryAvailable;
        this.memoryUsed = memoryUsed;
    }

    @Override
    @ProtoField(value=1)
    public String name() {
        return this.name;
    }

    @Override
    @ProtoField(value=2, collectionImplementation=ArrayList.class)
    public List<String> addresses() {
        return this.addresses;
    }

    @ProtoField(value=3, defaultValue="0")
    public long memoryAvailable() {
        return this.memoryAvailable;
    }

    @ProtoField(value=4, defaultValue="0")
    public long memoryUsed() {
        return this.memoryUsed;
    }

    public Json toJson() {
        return Json.object().set("node_name", (Object)this.name).set("node_addresses", Json.array((Object[])this.addresses.toArray())).set("memory_available", (Object)this.memoryAvailable).set("memory_used", (Object)this.memoryUsed);
    }

    public static NodeDistributionInfo resolve(CacheManagerInfo manager, GlobalComponentRegistry registry) {
        String name = manager.getNodeName();
        List addresses = manager.getPhysicalAddressesRaw();
        ContainerStats stats = (ContainerStats)registry.getComponent(ContainerStats.class);
        return new NodeDistributionInfo(name, addresses, stats.getMemoryAvailable(), stats.getMemoryUsed());
    }
}

