/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.health.Health;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheConfigurationAction;
import org.infinispan.security.actions.GetCacheConfigurationFromManagerAction;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetCacheManagerHealthAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static Configuration getCacheConfiguration(AdvancedCache<?, ?> cache) {
        GetCacheConfigurationAction action = new GetCacheConfigurationAction(cache);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static Configuration getCacheConfigurationFromManager(EmbeddedCacheManager cacheManager, String cacheName) {
        GetCacheConfigurationFromManagerAction action = new GetCacheConfigurationFromManagerAction(cacheManager, cacheName);
        return (Configuration)SecurityActions.doPrivileged(action);
    }

    static Health getHealth(EmbeddedCacheManager cacheManager) {
        GetCacheManagerHealthAction action = new GetCacheManagerHealthAction(cacheManager);
        return (Health)SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return (GlobalConfiguration)SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(cacheManager));
    }

    public static EncoderRegistry getEncoderRegistry(AdvancedCache<?, ?> cache) {
        return SecurityActions.doPrivileged(() -> (EncoderRegistry)cache.getCacheManager().getGlobalComponentRegistry().getComponent(EncoderRegistry.class));
    }
}

