/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6111)
public class JsonRespFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Object>> {
    @ProtoField(value=1)
    final byte[] path;

    @ProtoFactory
    public JsonRespFunction(byte[] path) {
        this.path = path;
    }

    public List<Object> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            return null;
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(jpath);
            ArrayList<Object> result = new ArrayList<Object>();
            for (JsonNode jsonNode : nodeList) {
                result.add(this.resp(jsonNode));
            }
            return result;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private Object resp(JsonNode jsonNode) {
        if (jsonNode.isArray()) {
            ArrayList<Object> arr = new ArrayList<Object>();
            arr.add(Character.valueOf('['));
            for (JsonNode jsonNode2 : (ArrayNode)jsonNode) {
                arr.add(this.resp(jsonNode2));
            }
            return arr;
        }
        if (jsonNode.isObject()) {
            ArrayList<Character> obj = new ArrayList<Character>();
            obj.add(Character.valueOf('{'));
            jsonNode.fields().forEachRemaining(entry -> {
                obj.add((Character)entry.getKey());
                obj.add((Character)this.resp((JsonNode)entry.getValue()));
            });
            return obj;
        }
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isLong()) {
            return jsonNode.asLong();
        }
        if (jsonNode.isFloat() || jsonNode.isDouble()) {
            return jsonNode.asDouble();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isTextual()) {
            return jsonNode.asText();
        }
        if (jsonNode.isNull()) {
            return null;
        }
        return jsonNode.toString();
    }
}

