/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.security.actions.SecurityActions;
import org.infinispan.server.resp.json.JsonArrayAppendFunction;
import org.infinispan.server.resp.json.JsonArrindexFunction;
import org.infinispan.server.resp.json.JsonArrinsertFunction;
import org.infinispan.server.resp.json.JsonArrpopFunction;
import org.infinispan.server.resp.json.JsonArrtrimFunction;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.server.resp.json.JsonClearFunction;
import org.infinispan.server.resp.json.JsonDebugMemoryFunction;
import org.infinispan.server.resp.json.JsonDelFunction;
import org.infinispan.server.resp.json.JsonGetFunction;
import org.infinispan.server.resp.json.JsonLenArrayFunction;
import org.infinispan.server.resp.json.JsonLenObjFunction;
import org.infinispan.server.resp.json.JsonLenStrFunction;
import org.infinispan.server.resp.json.JsonMergeFunction;
import org.infinispan.server.resp.json.JsonNumIncrOpFunction;
import org.infinispan.server.resp.json.JsonNumMultOpFunction;
import org.infinispan.server.resp.json.JsonObjkeysFunction;
import org.infinispan.server.resp.json.JsonRespFunction;
import org.infinispan.server.resp.json.JsonSetFunction;
import org.infinispan.server.resp.json.JsonStringAppendFunction;
import org.infinispan.server.resp.json.JsonToggleFunction;
import org.infinispan.server.resp.json.JsonTypeFunction;
import org.infinispan.util.function.SerializableFunction;

public class EmbeddedJsonCache {
    public static final String ERR_KEY_CAN_T_BE_NULL = "key can't be null";
    public static final String ERR_VALUE_CAN_T_BE_NULL = "value can't be null";
    protected final FunctionalMap.ReadWriteMap<byte[], JsonBucket> readWriteMap;
    protected final AdvancedCache<byte[], JsonBucket> cache;
    protected final InternalEntryFactory entryFactory;

    public EmbeddedJsonCache(Cache<byte[], JsonBucket> cache) {
        this.cache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(this.cache);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entryFactory = (InternalEntryFactory)SecurityActions.getCacheComponentRegistry(this.cache).getInternalEntryFactory().running();
    }

    public CompletionStage<byte[]> get(byte[] key, List<byte[]> paths, byte[] space, byte[] newline, byte[] indent) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonGetFunction(paths, space, newline, indent));
    }

    public CompletionStage<String> set(byte[] key, byte[] value, byte[] path, boolean nx, boolean xx) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(value, ERR_VALUE_CAN_T_BE_NULL);
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonSetFunction(value, path, nx, xx));
    }

    public CompletionStage<List<Long>> arrLen(byte[] key, byte[] path) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonLenArrayFunction(path));
    }

    public CompletionStage<List<Long>> srtLen(byte[] key, byte[] path) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonLenStrFunction(path));
    }

    public CompletionStage<List<Long>> objLen(byte[] key, byte[] path) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonLenObjFunction(path));
    }

    public CompletionStage<List<String>> type(byte[] key, byte[] path) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonTypeFunction(path));
    }

    public CompletionStage<Long> del(byte[] key, byte[] path) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonDelFunction(path));
    }

    public CompletionStage<List<Long>> arrAppend(byte[] key, byte[] path, List<byte[]> values) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonArrayAppendFunction(path, values));
    }

    public CompletionStage<List<Long>> strAppend(byte[] key, byte[] path, byte[] value) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonStringAppendFunction(path, value));
    }

    public CompletionStage<List<Integer>> toggle(byte[] key, byte[] path) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonToggleFunction(path));
    }

    public CompletionStage<List<List<byte[]>>> objKeys(byte[] key, byte[] path) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonObjkeysFunction(path));
    }

    public CompletionStage<List<Number>> numIncBy(byte[] key, byte[] path, byte[] value) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonNumIncrOpFunction(path, value));
    }

    public CompletionStage<List<Number>> numMultBy(byte[] key, byte[] path, byte[] value) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonNumMultOpFunction(path, value));
    }

    public CompletionStage<Integer> clear(byte[] key, byte[] path) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonClearFunction(path));
    }

    public CompletionStage<List<Integer>> arrIndex(byte[] key, byte[] jsonPath, byte[] value, int start, int stop, boolean isLegacy) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonArrindexFunction(jsonPath, value, start, stop, isLegacy));
    }

    public CompletionStage<List<Integer>> arrInsert(byte[] key, byte[] jsonPath, int index, List<byte[]> values) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonArrinsertFunction(jsonPath, index, values));
    }

    public CompletionStage<List<Integer>> arrTrim(byte[] key, byte[] jsonPath, int start, int stop) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonArrtrimFunction(jsonPath, start, stop));
    }

    public CompletionStage<List<byte[]>> arrpop(byte[] key, byte[] jsonPath, int index) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonArrpopFunction(jsonPath, index));
    }

    public CompletionStage<String> merge(byte[] key, byte[] jsonPath, byte[] value) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonMergeFunction(jsonPath, value));
    }

    public CompletionStage<List<Object>> resp(byte[] key, byte[] jsonPath) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonRespFunction(jsonPath));
    }

    public CompletionStage<List<Long>> debug(byte[] key, byte[] jsonPath) {
        return this.readWriteMap.eval((Object)key, (SerializableFunction)new JsonDebugMemoryFunction(jsonPath));
    }
}

