/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.time.TimeService;

public class RespUtil {
    private RespUtil() {
    }

    public static boolean isAsciiBytesEquals(byte[] expected, byte[] target) {
        if (expected.length != target.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            assert (RespUtil.isAsciiUppercase(expected[i])) : "Expected byte is not uppercase ASCII";
            byte l = target[i];
            assert (RespUtil.isAsciiChar(l)) : "Target byte is not ASCII";
            byte r = expected[i];
            if (l == r || l == r + 32) continue;
            return false;
        }
        return true;
    }

    public static boolean isAsciiBytesEquals(byte[] expected, String target) {
        if (expected.length != target.length()) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            assert (RespUtil.isAsciiUppercase(expected[i])) : "Expected byte is not uppercase ASCII";
            char c = target.charAt(i);
            assert (c < '\u0100');
            byte l = (byte)c;
            assert (RespUtil.isAsciiChar(l)) : "Target byte is not ASCII";
            byte r = expected[i];
            if (l == r || l == r + 32) continue;
            return false;
        }
        return true;
    }

    public static boolean caseInsensitiveAsciiCheck(char expected, byte actual) {
        assert (RespUtil.isAsciiUppercase((byte)expected)) : "Expected byte is not uppercase ASCII";
        assert (RespUtil.isAsciiChar(actual)) : "Target byte is not ASCII";
        return expected == actual || expected == actual - 32;
    }

    public static boolean isAsciiChar(byte b) {
        return RespUtil.isAsciiLowercase(b) || RespUtil.isAsciiUppercase(b);
    }

    public static boolean isAsciiUppercase(byte b) {
        return b >= 65 && b <= 90;
    }

    public static boolean isAsciiLowercase(byte b) {
        return b >= 97 && b <= 122;
    }

    public static String utf8(byte[] b) {
        return new String(b, StandardCharsets.UTF_8);
    }

    public static String ascii(byte[] b) {
        return new String(b, StandardCharsets.US_ASCII);
    }

    public static long toUnixTime(long time, TimeService timeService) {
        if (time < 0L) {
            return time;
        }
        long unixTime = time + timeService.wallClockTime();
        return unixTime < 0L ? 0L : unixTime;
    }

    public static long fromUnixTime(long unixTime, TimeService timeService) {
        if (unixTime < 0L) {
            return unixTime;
        }
        long time = unixTime - timeService.wallClockTime();
        return time < 0L ? 0L : time;
    }

    public static boolean isWrongTypeError(Throwable t) {
        while (t instanceof CompletionException || t instanceof CacheException || t instanceof ExecutionException) {
            t = t.getCause();
        }
        return t instanceof ClassCastException || t instanceof IllegalArgumentException && t.getMessage().contains("No marshaller registered for object of Java type");
    }
}

