/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization;

import java.util.Collection;
import java.util.Map;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.serialization.SerializationHint;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Resp3Type implements SerializationHint.SimpleHint
{
    SIMPLE_STRING{

        @Override
        public void serialize(Object object, ResponseWriter writer) {
            writer.simpleString((CharSequence)object);
        }
    }
    ,
    BULK_STRING{

        @Override
        public void serialize(Object object, ResponseWriter writer) {
            if (object instanceof byte[]) {
                writer.string((byte[])object);
            } else {
                writer.string((CharSequence)object);
            }
        }
    }
    ,
    BULK_STRING_OR_MISSING{

        @Override
        public void serialize(Object object, ResponseWriter writer) {
            if (object instanceof byte[]) {
                if (((byte[])object).length == 0) {
                    writer.nulls();
                } else {
                    writer.string((byte[])object);
                }
            } else {
                writer.string((CharSequence)object);
            }
        }
    }
    ,
    INTEGER{

        @Override
        public void serialize(Object object, ResponseWriter writer) {
            writer.integers((Number)object);
        }
    }
    ,
    DOUBLE{

        @Override
        public void serialize(Object object, ResponseWriter writer) {
            writer.doubles((Number)object);
        }
    }
    ,
    AUTO{

        @Override
        public void serialize(Object object, ResponseWriter writer) {
            if (object instanceof CharSequence) {
                CharSequence s = (CharSequence)object;
                writer.string(s);
            } else if (object instanceof Number) {
                Number n = (Number)object;
                writer.integers(n);
            } else if (object instanceof Collection) {
                Collection c = (Collection)object;
                writer.array(c, AUTO);
            } else if (object instanceof Map) {
                Map m = (Map)object;
                writer.map(m, AUTO);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    };


    @Override
    public abstract void serialize(Object var1, ResponseWriter var2);
}

