/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.generic.EXPIRE;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class PERSIST
extends RespCommand
implements Resp3Command {
    public PERSIST() {
        super(2, 1, 1, 1, AclCategory.KEYSPACE.mask() | AclCategory.WRITE.mask() | AclCategory.FAST.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] keyBytes = arguments.get(0);
        return handler.stageToReturn(PERSIST.persist(handler, keyBytes), ctx, ResponseWriter.INTEGER);
    }

    private static CompletableFuture<Long> persist(Resp3Handler handler, byte[] keyBytes) {
        return handler.cache().getCacheEntryAsync((Object)keyBytes).thenCompose(e -> {
            if (e == null || e.getLifespan() < 0L) {
                return EXPIRE.NOT_APPLIED;
            }
            return handler.cache().replaceAsync((Object)((byte[])e.getKey()), (Object)((byte[])e.getValue()), (Object)((byte[])e.getValue())).thenCompose(replaced -> replaced != false ? EXPIRE.APPLIED : PERSIST.persist(handler, keyBytes));
        });
    }
}

