/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import org.infinispan.server.core.ProtocolDetector;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.AccessControlFilter;
import org.infinispan.server.core.transport.CacheInitializeInboundAdapter;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.logging.Log;

public class RespDetector
extends ProtocolDetector {
    public static final String NAME = "resp-detector";
    private static final Pattern RESP3_HANDSHAKE = Pattern.compile("^(?is)\\*[1-9]\r\n\\$[1-9]\r\n(HELLO|AUTH|COMMAND|SELECT)\r\n.*");

    public RespDetector(RespServer server) {
        super((ProtocolServer)server);
    }

    public String getName() {
        return NAME;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 5) {
            return;
        }
        int i = in.readerIndex();
        if (in.getByte(i) == 42) {
            CharSequence handshake = in.getCharSequence(i, in.readableBytes(), StandardCharsets.US_ASCII);
            if (RESP3_HANDSHAKE.matcher(handshake).matches()) {
                this.installRespHandler(ctx);
            } else {
                out.add("-ERR Only RESP3 supported\r\n");
            }
        } else if (in.getCharSequence(i, 5, StandardCharsets.US_ASCII).equals("HELLO")) {
            this.installRespHandler(ctx);
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private void installRespHandler(ChannelHandlerContext ctx) {
        this.trimPipeline(ctx);
        ctx.pipeline().addLast(new ChannelHandler[]{this.server.getInitializer()});
        Log.SERVER.tracef("Detected RESP connection %s", ctx);
        ctx.pipeline().fireUserEventTriggered((Object)AccessControlFilter.EVENT);
        ctx.pipeline().fireUserEventTriggered(CacheInitializeInboundAdapter.CACHE_INITIALIZE_EVENT);
    }
}

