/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.RespConstants;
import org.infinispan.server.resp.serialization.ResponseSerializer;

final class ByteBufBigNumberSerializer
implements ResponseSerializer<BigInteger, ByteBufPool> {
    static final ByteBufBigNumberSerializer INSTANCE = new ByteBufBigNumberSerializer();

    ByteBufBigNumberSerializer() {
    }

    @Override
    public void accept(BigInteger bigInteger, ByteBufPool alloc) {
        String value = bigInteger.toString(10);
        int size = 1 + value.length() + RespConstants.CRLF.length;
        alloc.acquire(size).writeByte(40).writeBytes(value.getBytes(StandardCharsets.US_ASCII)).writeBytes(RespConstants.CRLF);
    }

    @Override
    public boolean test(Object object) {
        return object instanceof BigInteger;
    }
}

