/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.server.resp.json.InfinispanJacksonJsonNodeProvider;

public class JSONUtil {
    private static byte JSON_ROOT_BYTE = (byte)36;
    public static byte[] JSON_ROOT = new byte[]{36};
    public static final Configuration configForDefiniteSet = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForDefiniteSet = JsonPath.using((Configuration)configForDefiniteSet);
    public static final Configuration configForSet = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForSet = JsonPath.using((Configuration)configForSet);
    public static final Configuration configForGet = Configuration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new InfinispanJacksonJsonNodeProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static final ParseContext parserForGet = JsonPath.using((Configuration)configForGet);
    public static final Configuration configForMod = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForMod = JsonPath.using((Configuration)configForMod);
    public static final Configuration configForDefiniteMod = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).build();
    public static ParseContext parserForDefiniteMod = JsonPath.using((Configuration)configForMod);
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public static boolean isRoot(byte[] path) {
        return path != null && path.length == 1 && path[0] == JSON_ROOT_BYTE;
    }

    public static String toJsonPath(String path) {
        Object step1Result = !JSONUtil.isJsonPath(path) ? (path.startsWith(".") ? (path.length() == 1 ? "$" : "$" + path) : "$." + path) : path;
        return JSONUtil.convertRedisFilterToJayway((String)step1Result);
    }

    public static byte[] toJsonPath(byte[] path) {
        if (path != null && path.length == 1 && path[0] == 46) {
            return JSON_ROOT;
        }
        String pathStr = new String(path, StandardCharsets.UTF_8);
        String converted = JSONUtil.toJsonPath(pathStr);
        return converted.equals(pathStr) ? path : converted.getBytes(StandardCharsets.UTF_8);
    }

    public static boolean isJsonPath(byte[] path) {
        return path != null && path.length > 0 && path[0] == JSON_ROOT_BYTE && (path.length < 2 || path[1] == 46 || path[1] == 91);
    }

    public static boolean isJsonPath(String path) {
        return path == null ? false : JSONUtil.isJsonPath(path.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean isValueInvalid(byte[] value) {
        if (value.length == 0) {
            return true;
        }
        if (value.length == 1) {
            return JSONUtil.isSingleCharInvalid(value[0]);
        }
        if (value.length == 2) {
            return JSONUtil.isDoubleCharInvalid(value);
        }
        return false;
    }

    private static boolean isSingleCharInvalid(byte value) {
        switch (value) {
            case 0: 
            case 10: 
            case 12: 
            case 32: 
            case 39: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private static boolean isDoubleCharInvalid(byte[] value) {
        if (value[0] == 92 && (value[1] == 92 || value[1] == 34 || value[1] == 91)) {
            return true;
        }
        if (value[0] == 123 && value[1] == 93) {
            return true;
        }
        return value[0] == 91 && value[1] == 125;
    }

    private static String toJaywayRegex(String redisRegex) {
        boolean isQuoted;
        if (redisRegex == null || redisRegex.isBlank()) {
            throw new IllegalArgumentException("Regex cannot be null or empty");
        }
        Object pattern = redisRegex.trim();
        boolean bl = isQuoted = ((String)pattern).startsWith("\"") && ((String)pattern).endsWith("\"");
        if (isQuoted && ((String)pattern).length() >= 2) {
            pattern = ((String)pattern).substring(1, ((String)pattern).length() - 1);
        }
        boolean startsWithAnchor = ((String)pattern).startsWith("^");
        boolean endsWithAnchor = ((String)pattern).endsWith("$");
        boolean hasLeadingWildcard = ((String)pattern).startsWith(".*");
        boolean hasTrailingWildcard = ((String)pattern).endsWith(".*");
        if (isQuoted) {
            if (!startsWithAnchor && !hasLeadingWildcard) {
                pattern = ".*" + (String)pattern;
            }
            if (!endsWithAnchor && !hasTrailingWildcard) {
                pattern = (String)pattern + ".*";
            }
            return "/" + (String)pattern + "/";
        }
        return pattern;
    }

    public static String convertRedisFilterToJayway(String redisFilter) {
        if (redisFilter == null || redisFilter.isBlank()) {
            throw new IllegalArgumentException("Filter cannot be null or empty");
        }
        Pattern p = Pattern.compile("=~\\s*\"([^\"]+)\"");
        Matcher m = p.matcher(redisFilter);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            String redisRegex = "\"" + m.group(1) + "\"";
            String jaywayRegex = JSONUtil.toJaywayRegex(redisRegex);
            m.appendReplacement(sb, "=~ " + jaywayRegex);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

