/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.set;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.multimap.impl.SetBucket;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.set.SINTER;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class SUNION
extends RespCommand
implements Resp3Command {
    public SUNION() {
        super(-2, 1, -1, 1, AclCategory.READ.mask() | AclCategory.SET.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        EmbeddedSetCache<byte[], byte[]> esc = handler.getEmbeddedSetCache();
        Set<byte[]> uniqueKeys = SINTER.getUniqueKeys(handler, arguments);
        CompletableFuture allEntries = esc.getAll(uniqueKeys);
        return handler.stageToReturn(allEntries.thenApply(sets -> SUNION.union(sets.values())), ctx, ResponseWriter.SET_BULK_STRING);
    }

    public static Set<byte[]> union(Collection<SetBucket<byte[]>> sets) {
        HashSet<byte[]> result = new HashSet<byte[]>();
        for (SetBucket<byte[]> setBucket : sets) {
            if (setBucket == null) continue;
            for (byte[] el : setBucket.toSet()) {
                if (el == null || !result.stream().noneMatch(v -> Objects.deepEquals(v, el))) continue;
                result.add(el);
            }
        }
        return result;
    }
}

